"use strict";console.info("*****************************************"),console.info("* QNix 9500 Application                 *"),console.info("* (c) Automation Dr. Nix, Germany, 2025 *"),console.info("*****************************************\n"),console.info("Modul app loaded...");const express=require("express"),path=require("path");let bodyParser=require("body-parser"),HTMLing=require("htmling");const interfaceEvents=require("events");let langFile,QN8Set=require("./routes/QN8Set"),helpSupport=require("./routes/helpSupport"),fileSync=require("./routes/fileSync"),report=require("./routes/report"),job=require("./routes/job"),gaugeSettings=require("./routes/gaugeSettings.js"),buildPdf=require("./routes/buildPdf"),gauge=require("./bin/gauge.js"),communication=require("./bin/communication.js"),applicationLayer=require("./bin/applicationLayer.js"),QNfile=require("./bin/QNfile.js"),comEvents=new interfaceEvents;const CompanyTitle="QNix &#169;";function Settings(){this.SettingsPath=path.join(__dirname,"data","settings.json"),this.port=8080,this.language="eng"}Settings.prototype.load=function(){let settingsFile,fs=require("fs-extra");console.log("Settings path : "+this.SettingsPath);try{settingsFile=fs.readJsonSync(this.SettingsPath),this.port=settingsFile.port,this.language=settingsFile.language}catch(err){console.error("error - file error; settings.json can't load")}},Settings.prototype.save=function(lang){let fs=require("fs-extra");this.language=lang;try{fs.writeJsonSync(this.SettingsPath,{port:this.port,language:lang}),console.info("settings.json update; lang = "+lang)}catch(err){console.error("error - file error; settings.json can't saved")}};let loadLanguageFile=function(lang){try{const pathFile=path.join(__dirname,"public","Locale",lang+".json");console.info("Load language data : "+pathFile),langFile=require(pathFile),settings.save(lang)}catch(err){console.error("ERROR - no language files! Exit! "+err.message),process.exit(-1)}langFile={translation:langFile,companyTitle:CompanyTitle}},getTranslation=function(tagList){let translationList={};for(let i=0;i<tagList.length;i++)try{translationList[tagList[i]]=langFile.translation[tagList[i]]}catch(err){translationList[tagList[i]]="???"}return translationList},settings=new Settings;settings.load(),loadLanguageFile(settings.language);let app=express();app.engine("html",HTMLing.express(__dirname+"/views/")),app.set("view engine","html"),app.use(bodyParser.json()),app.use(bodyParser.urlencoded({limit:"10mb",extended:!0})),app.use(express.static(path.join(__dirname,"public"))),app.all("/QN8Set/*",QN8Set),app.get("/help/*",helpSupport),app.all("/report/*",report),app.all("/sync/*",fileSync),app.all("/job/*",job),app.all("/gauge/*",gaugeSettings),app.all("/buildpdf/*",buildPdf),app.use("/*",(function(req,res){let adr=req.baseUrl.replace("/","");0===adr.length?res.render(path.join(__dirname,"views","/start"),langFile):res.render(path.join(__dirname,"views",adr),langFile)})),app.use((function(req,res,next){let err=new Error("Not Found");err.status=404,next(err)})),app.use((function(err,req,res,next){res.status(500),"/certificate.pdf"===req.url?res.render(path.join(__dirname,"views","certificate.html")):"/certificate1.html"===req.url||"/certificate2.html"===req.url?res.render(path.join(__dirname,"views","certificateEmpty.html")):res.render(path.join(__dirname,"views","/error"),{message:err.message,status:err.status})}));let io=require("socket.io")(80);io.sockets.on("connection",(function(socket){console.log("Connect over webSocket client"),communication.getStateUSB()})),io.sockets.on("error",(function(){console.error("Error webSocket client")})),io.sockets.on("disconnect",(function(){console.info("shutdown...")})),gaugeSettings.setModulReference(io,gauge,QNfile,communication,applicationLayer),fileSync.setModulReference(io,QNfile),report.setModulReference(QNfile),job.setModulReference(QNfile),QN8Set.setModulReference(QNfile,loadLanguageFile,getTranslation,settings.language,applicationLayer),buildPdf.setModulReference(io,QNfile),helpSupport.submitReference(QNfile),communication.referModule(io,applicationLayer.getDataHandler(),QNfile.setDrive,comEvents),applicationLayer.referModule(communication.getDataHandler(),communication.get_setBaudRateMethod(),communication.setResponseObject(),io,comEvents),module.exports=app,setTimeout((function(){communication.initUSBEvents()}),700);