"use strict";const Path=require("path"),fs=require("fs-extra"),Reports=require("./reportElements"),conv=require("./convert.js"),generation=require("./generation.js");console.info("Modul QNfile loading...");const MaxSD=9990,MaxPages=2500,MaxReadings=25e4,MaxAreas=100,NameFile="INFO.JSN",GaugeSystemSettingsFile="USER.JSN",ProbeSettingsFile="PROBE.JLG",GlobalProbeSettingsFile="PROBE.JSN",GaugeJustFile="ADJUST.JSN",LimitFile="LIMITS.JSN",MeasurementFile="MSMTS.DAT",AdjustLogFile="ADJUST.JLG",AdjustLogFileFe="APTS_FE.JLG",AdjustLogFileNFe="APTS_NFE.JLG",SystemFileReportTemplate="struct.json",DeviceFile="device.json",ErrorFile_Info={name:"?????"},TempFileReport=Path.join(Path.dirname(__dirname),"public","tempReport.html"),TempFilePreviewPage=Path.join(Path.dirname(__dirname),"public","previewPage.html"),fileReadings=Path.join(__dirname,"../","public","mDataTemp.json"),EnumReportElementType={none:0,header:1,textblock:2,textblock1_2:4,textblock2_1:3,textblock2_2:5,textblock_adr:6,textblock_adr_customer:7,textblock_spec1:8,signature:9,check:10,contract:11,certificate:13,limit1:20,just1:22,devinfo:29,table1:30,table2:31,table3:32,table1J:40,table1C:41,table3J:42,table2J:43,chart_JL1:70,chart_JH1:71,chart_JC1:72,img1:80,img1_2:81,footer:90,formfeed:91,end:92};let Norm_List=[{id:"custom",text:"Eigene Einstellung"},{id:"iso2808",text:"ISO  2808"},{id:"iso12944",text:"ISO 12944"},{id:"iso19840",text:"ISO 19840"},{id:"astm",text:"ASTM 7091-5"},{id:"imo",text:"IMO-MSC215"},{id:"sspc",text:"SSPC PA2 Level all"},{id:"sspc3",text:"SSPC PA2 Level 3 (default)"}];const pathUserDirectory=Path.join(process.env.PUBLIC,"Automation"),Prefix_Area="AREA",Prefix_Job="JOB",PathListDefinition={QN8job:"User\\jobs",QN8templateJob:"User\\templates",QN8templateReport:"User\\reportTemplates",QN8report:"User\\reports",HGjob:"JOBS",HGtemplateJob:"TEMPLATS",HGtemplateReport:"reportTemplates",HGreport:"REPORTS",HGsystem:"SYSTEM",HG_drive:"",HG_COM:"",HG_name:"",currentHGjob:"",currentHGtemplateJob:"",currentHGtemplateReport:"",currentHGreport:"",currentHGsystem:"",ConfigPath:"data\\path.json",currentQN8Toolbox:"data\\report_QN\\eng",currentPdfPath:""};let PathList,justifyLogData,devInfoData,currentTemplateReport={path:"",name:""},TimeOffset=0;function Directory(){this.Name="",this.Path="",this.Type="",this.Readonly=!1}Directory.prototype.readHeader=function(){let j,path=Path.join(this.Path,NameFile);try{j=fs.readJsonSync(path),this.Name=j.name}catch(error){console.error("error - can not read info.jsn : "+path),this.Name=ErrorFile_Info.name;try{fs.writeJsonSync(path,ErrorFile_Info),console.log("write new INFO.JSN")}catch(error){console.error("fatal error - can't write new info.jsn to fix error : "+path),this.Name="?Error?"}return!0}return!1},Directory.prototype.writeHeader=function(){if(""!==this.Name){let filePath=Path.join(this.Path,NameFile),file={name:this.Name};try{fs.writeJsonSync(filePath,file)}catch(err){console.info("error - write info.jsn path:"+filePath)}}},Directory.prototype.writeStruct=function(){fs.writeJson(Path.join(this.Path,"struct.json"),{elements:this.Elements,readonly:this.Readonly},(function(err){if(err)throw console.error("Error ! struct.json not saved"),err}))},Directory.prototype.getType=function(path){let stat;this.Path=path;try{stat=fs.statSync(path).isDirectory()}catch(err1){return void(this.Type="undefined")}let name=Path.basename(path);if(stat)if("R_"===name.substr(0,2)&&6===name.length)this.Type="rep",this.readHeader();else if("RT"===name.substr(0,2)&&6===name.length){this.Type="rept",this.readHeader();try{let templateContent=fs.readJsonSync(Path.join(path,"struct.json"));this.Readonly=templateContent.readonly}catch(err){console.info("error - "+path+" struct.json error")}}else"JOB"===name.substr(0,3)&&7===name.length&&Path.dirname(path)===PathList.QN8job||Path.dirname(path)===PathList.currentHGjob?(this.Type="job",this.readHeader()):"JOB"===name.substr(0,3)&&7===name.length&&Path.dirname(path)===PathList.QN8templateJob||Path.dirname(path)===PathList.currentHGtemplateJob?(this.Type="jobt",this.readHeader()):this.Type="undefined";else switch(Path.extname(path)){case".pdf":this.Type="pdf",this.Name=Path.basename(path,".pdf");break;case".xlsx":this.Type="xlsx",this.Name=Path.basename(path,".xlsx");break;default:this.Type="unknown"}},Directory.prototype.copyReportFiles=function(reportTemplateName,sourceName,jobPath,allAreasFlg,areas){let list,destPath;if(void 0===reportTemplateName){list=getDirectoryList(PathList.QN8report);let reportPath="";for(let i=0;i<list.length;i++)if(list[i].Name===sourceName){reportPath=list[i].Path;break}return void(""!==reportPath&&(destPath=this.Path,fs.readdir(reportPath,(function(err,dir){let source,dest;for(let i=0;i<dir.length;i++)if(dir[i]!==NameFile&&"struct.json"!==dir[i]){source=Path.join(reportPath,dir[i]),dest=Path.join(destPath,dir[i]);try{fs.copySync(source,dest),console.log("file "+source+" copy to report folder")}catch(err){console.error("error - copy "+source+" from report to "+dest+" "+err.message)}}}))))}list=getDirectoryList(PathList.QN8templateReport);let reportTemplatePath="";for(let i=0;i<list.length;i++)if(list[i].Name===reportTemplateName){reportTemplatePath=list[i].Path;break}destPath=this.Path,""!==reportTemplatePath&&fs.readdir(reportTemplatePath,(function(err,dir){let source,dest;for(let i=0;i<dir.length;i++)if(dir[i]!==NameFile&&"struct.json"!==dir[i]){source=Path.join(reportTemplatePath,dir[i]),dest=Path.join(destPath,dir[i]);try{fs.copySync(source,dest),console.log("file "+source+" copy to report folder")}catch(err){console.error("error - copy "+source+" from report template to "+dest+" "+err.message)}}let jobDir=Path.join(destPath,"JOB0001");allAreasFlg?fs.copy(jobPath,jobDir,(function(err){err&&console.error("Error - creating error : copy job to report folder")})):fs.mkdir(jobDir,(err=>{fs.readdir(jobPath,(function(err,dir){for(let i=0;i<dir.length;i++)if(source=Path.join(jobPath,dir[i]),dest=Path.join(jobDir,dir[i]),"AREA"===dir[i].substring(0,4)){let areaName;try{areaName=fs.readJsonSync(Path.join(source,NameFile)).name;for(let areaIdx=0;areaIdx<areas.length;areaIdx++)if(areaName===areas[areaIdx])try{fs.copySync(source,dest);break}catch(err){console.error("Error - copy area from job "+source+" -> "+dest)}}catch(err){console.error("Error - copy area from job "+source)}}else try{fs.copySync(source,dest)}catch(err){console.error("Error - copy file from job "+source+" -> "+dest)}}))}))}))};let generateUserDirectories=function(readyFunc){fs.ensureDir(pathUserDirectory,(err=>{if(err)console.error("fatal error - create user directories (automation)"),readyFunc();else{let pathDir1=Path.join(pathUserDirectory,"jobs");fs.stat(pathDir1,((err,stats)=>{if(err){console.info("create user directories ("+pathDir1+")"),fs.ensureDirSync(pathDir1);Path.join(PathList.QN8job);console.log("copy "+PathList.QN8job+" to "+pathDir1),fs.copy(PathList.QN8job,pathDir1)}else console.log("info - user directory "+pathDir1+" ok");PathList.QN8job=pathDir1;let pathDir2=Path.join(pathUserDirectory,"reports");fs.stat(pathDir2,((err,stats)=>{if(err){console.info("create user directories ("+pathDir2+")"),fs.ensureDirSync(pathDir2);Path.join(PathList.QN8report);console.log("copy "+PathList.QN8report+" to "+pathDir2),fs.copy(PathList.QN8report,pathDir2)}else console.log("info - user directory "+pathDir2+" ok");PathList.QN8report=pathDir2;let pathDir3=Path.join(pathUserDirectory,"reportTemplates");fs.stat(pathDir3,((err,stats)=>{if(err){console.info("create user directories ("+pathDir3+")"),fs.ensureDirSync(pathDir3);Path.join(PathList.QN8templateReport);console.log("copy "+PathList.QN8templateReport+" to "+pathDir3),fs.copy(PathList.QN8templateReport,pathDir3)}else console.log("info - user directory "+pathDir3+" ok");PathList.QN8templateReport=pathDir3;let pathDir4=Path.join(pathUserDirectory,"templates");fs.stat(pathDir4,((err,stats)=>{if(err){console.info("create user directories ("+pathDir4+")"),fs.ensureDirSync(pathDir4);Path.join(PathList.QN8templateJob);console.log("copy "+PathList.QN8templateJob+" to "+pathDir4),fs.copy(PathList.QN8templateJob,pathDir4)}else console.log("info - user directory "+pathDir4+" ok");PathList.QN8templateJob=pathDir4,readyFunc()}))}))}))}))}}))},getDirectoryList=function(path){let list,directoryList=[];try{list=fs.readdirSync(path)}catch(err){return directoryList}for(let i=0;i<list.length;i++){let entry=new Directory;entry.getType(Path.join(path,list[i])),"undefined"!==entry.Type&&"unknown"!==entry.Type&&directoryList.push(entry)}return directoryList},BuildGaugePath=function(pathList){return 0===pathList.HG_drive.length?(pathList.currentHGtemplateJob="",pathList.currentHGjob="",pathList.currentHGtemplateReport="",pathList.currentHGreport="",pathList.currentHGsystem=""):(pathList.currentHGtemplateJob=Path.join(pathList.HG_drive,pathList.HGtemplateJob),pathList.currentHGjob=Path.join(pathList.HG_drive,pathList.HGjob),pathList.currentHGtemplateReport=Path.join(pathList.HG_drive,pathList.HGtemplateReport),pathList.currentHGreport=Path.join(pathList.HG_drive,pathList.HGreport),pathList.currentHGsystem=Path.join(pathList.HG_drive,pathList.HGsystem)),pathList};const pathFilePath=Path.join(Path.dirname(__dirname),PathListDefinition.ConfigPath);let generateNewPathFile=function(){PathList=PathListDefinition,PathList.QN8templateJob=Path.join(Path.dirname(__dirname),PathList.QN8templateJob),PathList.QN8templateReport=Path.join(Path.dirname(__dirname),PathList.QN8templateReport),PathList.QN8report=Path.join(Path.dirname(__dirname),PathList.QN8report),PathList.QN8job=Path.join(Path.dirname(__dirname),PathList.QN8job),generateUserDirectories((()=>{PathList.ConfigPath=Path.join(Path.dirname(__dirname),PathList.ConfigPath),PathList.currentQN8Toolbox=Path.join(Path.dirname(__dirname),PathList.currentQN8Toolbox),fs.writeJson(PathList.ConfigPath,PathList,(function(err){err?console.error("Error - routes/QN8set.js: path.json not saved : "+err.msg):console.info("path.json generated")}))}))},SaveAllPath=function(resultFunc){fs.writeJson(PathList.ConfigPath,PathList,resultFunc)},NextFreeFolder=function(directory,startString){let name,tst,val,folderIdx=[];for(let idx=0;idx<directory.length;idx++)name=Path.basename(directory[idx].Path),name.length===startString.length+4&&name.substring(0,startString.length)===startString&&(val=name.substr(startString.length,4),folderIdx.push(parseInt(val,16)));if(name="",0!==folderIdx.length){folderIdx.sort();for(let idx=1;idx<=65535;idx++){tst=!1;for(let i=0;i<folderIdx.length;i++)if(!(folderIdx[i]<idx)&&idx===folderIdx[i]){tst=!0;break}if(!tst){name=startString+conv.index2HexString(idx);break}}}else name=startString+"0001";return name},DeleteFileOrFolder=function(path){let errFlg;try{fs.removeSync(path),errFlg=!1}catch(error){errFlg=!0}return errFlg},importImgFile=function(folderPath,imagePath){let fName=Path.basename(imagePath),dest=Path.join(folderPath,fName);try{console.log("copy image: "+imagePath+" -> "+dest),fs.copySync(imagePath,dest)}catch(error){fName=""}return fName},copyFolder=function(source,direction,newName,type){let destPath="",err=!1;if(newName.length>=6&&newName.length<10){switch(type){case"job":destPath=direction?PathList.QN8job:PathList.currentHGjob;break;case"jobt":destPath=direction?PathList.QN8templateJob:PathList.currentHGtemplateJob;break;case"rep":destPath=direction?PathList.QN8report:PathList.currentHGreport;break;case"rept":destPath=direction?PathList.QN8templateReport:PathList.currentHGtemplateReport;break;default:return console.error("Error - unknown type to copy"),destPath}try{destPath=Path.join(destPath,newName),console.log("copyFolder - destPath = "+destPath);try{fs.mkdirSync(destPath)}catch(error){err=!0,console.error("Error - folder creating error, abort copy -> "+destPath)}err||(fs.copySync(source,destPath),console.log("COPY FOLDER "+source+" - > "+destPath+" Verzeichnis "+newName))}catch(error){console.info("Error - folder format unknown (Error 2)"),destPath=""}return destPath}return console.info("Error - folder format unknown (Error 1)"),destPath},saveDeviceJobFile=function(pathSource,info){if(null===info||0===Object.keys(info).length)return;let content,file=Path.join(pathSource,DeviceFile);try{content=fs.readJsonSync(file),console.log("update device info file...")}catch(err){content=[],console.log("create new device info file...")}let findFlg=!1;for(let i=0;i<content.length;i++)if(info.probe.serial===content[i].serial){findFlg=!0;break}findFlg||""!==info.probe.key&&""!==info.probe.serial&&content.push({designation:info.probe.designation,key:info.probe.key,serial:info.probe.serial}),findFlg=!1;for(let i=0;i<content.length;i++)if(info.gauge.serial===content[i].serial){findFlg=!0;break}findFlg||content.push({designation:info.gauge.designation,key:info.gauge.key,serial:info.gauge.serial});try{fs.writeJsonSync(file,content)}catch(err){console.error("error - write device info file "+error.message)}};function ReportToolbox(){this.list=[]}ReportToolbox.prototype.loadToolbox=function(){let elem,fPath,fList=[];this.list=[];try{fList=fs.readdirSync(PathList.currentQN8Toolbox);for(let i=0;i<fList.length;i++)"envelope.html"!==fList[i]&&(fPath=Path.join(PathList.currentQN8Toolbox,fList[i]),elem=fs.readJsonSync(fPath),this.list.push(elem))}catch(err){console.error("error - load error toolbox elements"),this.list=null}return this.list},ReportToolbox.prototype.getElementByID=function(id){let elem=null;for(let i=0;i<this.list.length;i++)if(this.list[i].ID===parseInt(id)){let temp=JSON.stringify(this.list[i]);elem=JSON.parse(temp);break}return elem};let job,reportToolbox=new ReportToolbox,getJustifyLogDataJob=function(logPathFile){let content,data=[];try{content=fs.readFileSync(logPathFile,"utf8"),content=content.split("\n");for(let i=0;i<content.length;i++)""!==content[i]&&(content[i]=JSON.parse(content[i]),data.push({time_stamp:content[i].time_stamp,adjust_rules_set_value:content[i].adjust_rules_set_value}))}catch(err){data=null}return data},getJustifyLogDataFeNFe=function(logPathFe,logPathNFe,unit){let content,foilstring,data=[],acc="mil"===unit?2:1;try{content=fs.readFileSync(logPathFe,"utf8"),content=content.split("\n");for(let i=0;i<content.length;i++)if(""!==content[i]){content[i]=JSON.parse(content[i]),foilstring="";for(let j=1;j<6;j++)"nan"!==content[i]["ref"+j]&&"inf"!==content[i]["ref"+j]&&(foilstring+="mil"===unit?(content[i]["ref"+j]/25.4).toFixed(acc)+"mil, ":content[i]["ref"+j]+"µm, ");foilstring.length>2&&", "===foilstring.substring(foilstring.length-2,foilstring.length)&&(foilstring=foilstring.substr(0,foilstring.length-2)),data.push({time_stamp:content[i].time_stamp,sub:"Fe",foils:foilstring,probe_serialnumber:content[i].probe_serialnumber})}content=fs.readFileSync(logPathNFe,"utf8"),content=content.split("\n");for(let i=0;i<content.length;i++)if(""!==content[i]){content[i]=JSON.parse(content[i]),foilstring="";for(let j=1;j<6;j++)"nan"!==content[i]["ref"+j]&&"inf"!==content[i]["ref"+j]&&(foilstring+="mil"===unit?(content[i]["ref"+j]/25.4).toFixed(acc)+"mil, ":content[i]["ref"+j]+"µm, ");foilstring.length>2&&", "===foilstring.substring(foilstring.length-2,foilstring.length)&&(foilstring=foilstring.substr(0,foilstring.length-2)),data.push({time_stamp:content[i].time_stamp,sub:"NFe",foils:foilstring,probe_serialnumber:content[i].probe_serialnumber})}}catch(err){data=null}return null!==data&&data.sort((function(a,b){return parseInt(a.time_stamp,16)-parseInt(b.time_stamp,16)})),data},findContractTitle=function(elemList){let elemIdx,contract="",elem=reportToolbox.getElementByID(EnumReportElementType.contract);for(elemIdx=0;elemIdx<elemList.length;elemIdx++)if(elemList[elemIdx].id===elem.ID){contract=elemList[elemIdx].content[0];break}return console.log("contract ID="+contract),contract},insertSpecValues=function(html,batch,unit){let val,htmlData=html,acc="mil"===unit?2:1;if("mil"===unit)for(let umCounter=0;umCounter<6;umCounter++)htmlData=htmlData.replace("µm","mil");htmlData=htmlData.replace("param0",batch.name),val=batch.spec.area_lowerlimit_active?batch.spec.area_lowerlimit_value.toFixed(acc):"-",htmlData=htmlData.replace("spec1",val),val=batch.spec.spot_under_active?batch.spec.spot_under_value.toFixed(acc):"-",htmlData=htmlData.replace("spec2",val),val=batch.spec.area_upperlimit_active?batch.spec.area_upperlimit_value.toFixed(acc):"-",htmlData=htmlData.replace("spec3",val),val=batch.spec.spot_over_active?batch.spec.spot_over_value.toFixed(acc):"-",htmlData=htmlData.replace("spec4",val),val=batch.spec.percent_over_ndft_active?batch.spec.percent_over_ndft_value:"-",htmlData=htmlData.replace("spec6",val),val=batch.spec.msmts_per_spot_active?batch.spec.msmts_per_spot_value:"-",htmlData=htmlData.replace("spec7",val),val="-";for(let i=0;i<Norm_List.length;i++)if(Norm_List[i].id===batch.spec.limits_rules_set_value){val=Norm_List[i].text;break}return htmlData=htmlData.replace("spec8",val),htmlData},generateElementHTML_system=function(maxPageHeight,elem,currentHeight){let result={currentHeight:0,nextElemFlg:!0,elemHTML:""};if(result.currentHeight+=elem.height,currentHeight+result.currentHeight>maxPageHeight)result.nextElemFlg=!1,result.currentHeight=maxPageHeight;else{let hgData=getHGData(),probeData=getProbeData();result.currentHeight+=currentHeight,result.elemHTML=elem.html.replace("param1",hgData.designation),result.elemHTML=result.elemHTML.replace("param2",hgData.item),result.elemHTML=result.elemHTML.replace("param3",hgData.sn),result.elemHTML=result.elemHTML.replace("param4",hgData.hw),result.elemHTML=result.elemHTML.replace("param5",hgData.fw),result.elemHTML=result.elemHTML.replace("param6",probeData.designation),result.elemHTML=result.elemHTML.replace("param7",probeData.item),result.elemHTML=result.elemHTML.replace("param8",probeData.sn),result.elemHTML=result.elemHTML.replace("param9",probeData.hw),result.elemHTML=result.elemHTML.replace("param10",probeData.fw)}return result},generateElementHTML=function(maxPageHeight,elem,report,type,currentHeight,batchIdx,mIdx,justPart){let paramIdx,paramContent,elemData,elemHTML="",nextElemFlg=!0;switch(elem.type){case EnumReportElementType.formfeed:elemHTML="",currentHeight=maxPageHeight;break;case EnumReportElementType.textblock:elemData=Reports.generateElementHTML_textblock(maxPageHeight,elem,currentHeight,100),nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.textblock1_2:elemData=Reports.generateElementHTML_textblock1_2(maxPageHeight,elem,currentHeight,100),nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.signature:elemData=Reports.generateElementHTML_signatur(maxPageHeight,elem,currentHeight,100),nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.textblock2_1:case EnumReportElementType.contract:case EnumReportElementType.textblock_spec1:case EnumReportElementType.textblock_adr_customer:elemData=Reports.generateElementHTML_textblock2_1(maxPageHeight,elem,currentHeight,100),nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.textblock2_2:elemData=Reports.generateElementHTML_textblock2_2(maxPageHeight,elem,currentHeight,100),nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.textblock_adr:if(currentHeight+elem.height>maxPageHeight){nextElemFlg=!1,currentHeight=maxPageHeight;break}elemHTML=elem.html.replace("param",elem.title),currentHeight=elem.height;break;case EnumReportElementType.check:elemData=Reports.generateElementHTML_check(maxPageHeight,elem,currentHeight,100),nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.img1:case EnumReportElementType.img1_2:elemData=Reports.generateElementHTML_img(maxPageHeight,elem,currentHeight),nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.table1J:elemData=Reports.generateElementHTML_table1J(maxPageHeight,elem,report,currentHeight,batchIdx,mIdx),batchIdx=elemData.batchIdx,mIdx=elemData.mIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.table1C:elemData=Reports.generateElementHTML_table1C(maxPageHeight,elem,report,currentHeight,batchIdx,mIdx),batchIdx=elemData.batchIdx,mIdx=elemData.mIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.table1:elemData=Reports.generateElementHTML_table1(maxPageHeight,elem,report,currentHeight,batchIdx,mIdx),batchIdx=elemData.batchIdx,mIdx=elemData.mIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.table2:elemData=Reports.generateElementHTML_table2(maxPageHeight,elem,report,currentHeight,batchIdx,mIdx),batchIdx=elemData.batchIdx,mIdx=elemData.mIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.table2J:elemData=Reports.generateElementHTML_table2J(maxPageHeight,elem,report,currentHeight,batchIdx),batchIdx=elemData.batchIdx,mIdx=0,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.limit1:elemData=Reports.generateElementHTML_limit(maxPageHeight,elem,report,currentHeight,batchIdx),batchIdx=elemData.batchIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.chart_JL1:elemData=Reports.generateElementHTML_chartJL1(maxPageHeight,elem,report,currentHeight,batchIdx,fileReadings),batchIdx=elemData.batchIdx,mIdx=0,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.chart_JC1:elemData=Reports.generateElementHTML_chartJC1(maxPageHeight,elem,report,currentHeight,batchIdx,fileReadings),batchIdx=elemData.batchIdx,mIdx=0,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.chart_JH1:elemData=Reports.generateElementHTML_chartJH1(maxPageHeight,elem,report,currentHeight,batchIdx),batchIdx=elemData.batchIdx,mIdx=0,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.just1:console.log("CURRENT height 1 "+currentHeight),1===justPart?(0===mIdx&&(justifyLogData=getJustifyLogDataJob(Path.join(report.jobPath,"ADJUST.JLG"))),elemData=Reports.generateElementHTML_just1A(maxPageHeight,elem,report.jobName,currentHeight,mIdx,justifyLogData,TimeOffset),mIdx=elemData.mIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight,justPart=elemData.part,console.log("CURRENT height 2 "+currentHeight)):(0===mIdx&&(justifyLogData=getJustifyLogDataFeNFe(Path.join(report.jobPath,"APTS_FE.JLG"),Path.join(report.jobPath,"APTS_NFE.JLG"),report.unit)),elemData=Reports.generateElementHTML_just1B(maxPageHeight,elem,report.jobName,currentHeight,mIdx,justifyLogData,TimeOffset),mIdx=elemData.mIdx,batchIdx=elemData.batchIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight,justPart=elemData.part,console.log("CURRENT height 3 "+currentHeight));break;case EnumReportElementType.devinfo:0===mIdx&&(devInfoData=Reports.getDeviceInfo(Path.join(report.jobPath,DeviceFile))),elemData=Reports.generateElementHTML_devInfo(maxPageHeight,elem,report,currentHeight,mIdx,devInfoData),mIdx=elemData.mIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;case EnumReportElementType.certificate:elemData=Reports.generateElementCertificate(maxPageHeight,elem,mIdx),mIdx=elemData.mIdx,nextElemFlg=elemData.nextElemFlg,elemHTML=elemData.elemHTML,currentHeight=elemData.currentHeight;break;default:elemHTML=elem.html.replace("param",elem.title)}if(elem.content.length>0)for(paramIdx=0;paramIdx<elem.param.length;paramIdx++)try{switch(elem.type){case EnumReportElementType.img1:case EnumReportElementType.img1_2:paramContent=""!==elem.imgPath[paramIdx]?"report/reqImg?file="+encodeURI(elem.imgPath[paramIdx])+"&type=Path":"report/reqImg?file="+elem.content[paramIdx]+"&type="+("rept"===type?"RT":"R_")+"&report="+report.name,elemHTML=elemHTML.replace("param"+(paramIdx+1),paramContent);break;case EnumReportElementType.textblock_adr:paramIdx===elem.param.length-1?(paramContent=""!==elem.imgPath[paramIdx]?"report/reqImg?file="+encodeURI(elem.imgPath[paramIdx])+"&type=Path":"report/reqImg?file="+elem.content[paramIdx]+"&type="+("rept"===type?"RT":"R_")+"&report="+report.name,elemHTML=elemHTML.replace("param_logo",paramContent)):(paramContent=elem.content[paramIdx],elemHTML=elemHTML.replace("param"+(paramIdx+1),paramContent));break;case EnumReportElementType.table1:break;default:paramContent=elem.content[paramIdx],elemHTML=elemHTML.replace("param"+(paramIdx+1),paramContent)}}catch(err){paramContent="",elemHTML=elemHTML.replace("param"+(paramIdx+1),paramContent)}return{html:elemHTML,height:currentHeight,nextElemFlg:nextElemFlg,batchIdx:batchIdx,mIdx:mIdx,justPart:justPart}},getStartAndEndHtmlSections=function(asiaFlg,pageFormatStr){let filePath=Path.join(PathList.currentQN8Toolbox,"envelope.html"),emptyHtmlPage=fs.readFileSync(filePath).toString();if(""===emptyHtmlPage)return console.error("error - file envelope.html not found"),{start:"",end:""};let bodyParts=emptyHtmlPage.split("$");return bodyParts[0]=asiaFlg?bodyParts[0].replace("#","Asia"+pageFormatStr):bodyParts[0].replace("#",pageFormatStr),{start:bodyParts[0],end:bodyParts[1]}},buildHTMLReport=function(mode,report,resultFunc){let elem,currentPageFooterHTML,elemNo=0,pageNo=1,elemData={html:"",height:0,nextElemFlg:!0,batchIdx:0,mIdx:0,justPart:1};try{fs.removeSync(TempFileReport)}catch(err){resultFunc(!0,0),console.error("error - delete old report html file")}let currentPage,maxHeight,type=""===report.name?"rept":"rep",pageHeaderHTML=reportToolbox.getElementByID(EnumReportElementType.header).html,pageFooter=reportToolbox.getElementByID(EnumReportElementType.footer),envelope=getStartAndEndHtmlSections(report.asiaFlg,report.pageformat);for(maxHeight="Letter"===report.pageformat?1338:1502,pageFooter.html=pageFooter.html.replace("param1",findContractTitle(report.elements)),currentPage=envelope.start,currentPage+=pageHeaderHTML,void 0===report.batches&&(report.batches=[]);elemNo<report.elements.length;){if(console.log("  > Process Elem "+elemNo+"/"+report.elements.length+" ID="+report.elements[elemNo].id),elemData.nextElemFlg&&(elemData.batchIdx=0,elemData.mIdx=0,elem=reportToolbox.getElementByID(parseInt(report.elements[elemNo].id)),elem.title=report.elements[elemNo].title,elem.type!==EnumReportElementType.footer&&(elem.content=report.elements[elemNo].content,elem.imgPath=report.elements[elemNo].imgPath)),elemData=generateElementHTML(maxHeight,elem,report,type,elemData.height,elemData.batchIdx,elemData.mIdx,elemData.justPart),currentPage+=elemData.html,elemData.height>=maxHeight||elem.type===EnumReportElementType.formfeed){if(!mode)break;currentPageFooterHTML=pageFooter.html.replace("param2",pageFooter.content[1]+pageNo.toString()),currentPage+=currentPageFooterHTML,fs.appendFileSync(TempFileReport,currentPage),pageNo++,elemData.height=0,currentPage=pageHeaderHTML}elemData.nextElemFlg&&elemNo++}currentPageFooterHTML=pageFooter.html.replace("param2",pageFooter.content[1]+pageNo.toString()),currentPage+=currentPageFooterHTML,currentPage+=envelope.end;try{fs.appendFileSync(TempFileReport,currentPage)}catch(err){return void resultFunc(!0,0)}resultFunc(!1,pageNo)},overwriteJob=function(jobPath,newBatchLst,unit){let batchDir,infoFile,limitFile,bIdx,i,batchLst=new BatchDirectory(jobPath);batchLst.getBatchList(unit),batchLst.delAllBatches();for(let idx=0;idx<newBatchLst.length;idx++){for(bIdx=(newBatchLst.length-idx).toString(16).toUpperCase(),i=bIdx.length;i<4;i++)bIdx="0"+bIdx;batchDir="AREA"+bIdx,batchDir=Path.join(jobPath,batchDir),fs.mkdirSync(batchDir),infoFile=Path.join(batchDir,NameFile),limitFile=Path.join(batchDir,LimitFile),fs.writeJsonSync(infoFile,{name:newBatchLst[idx].name}),fs.writeJsonSync(limitFile,newBatchLst[idx].spec)}console.log("job was updated")},newJobTemplate=function(jobTemplateLst,name,newBatchLst,unit){let newJobTemplate=new Directory,newFolderName=NextFreeFolder(jobTemplateLst,"JOB");newJobTemplate.Path=Path.join(PathList.QN8templateJob,newFolderName),newJobTemplate.Name=name,newJobTemplate.Type="job";try{fs.mkdirSync(newJobTemplate.Path),newJobTemplate.writeHeader()}catch(error){return void console.info("Error - creating error : new folder for a job template")}new BatchDirectory(newJobTemplate.Path).createNewEmptyBatches(newBatchLst),console.log("new job template is generated")};function StatisticalVal(){this.min=0,this.max=0,this.sum=0,this.avg=0,this.var=0,this.dev=0,this.okFlg=!1,this.n=0}function Batch(){this.name="",this.fileIndex=0,this.spec={},this.m=[],this.count=0,this.path_m="",this.statFe=new StatisticalVal,this.statNFe=new StatisticalVal,this.statAll=new StatisticalVal,this.isEmpty=!0}function BatchDirectory(path){this.path=path,this.name="",this.list=[],this.count=0}StatisticalVal.prototype.convert=function(unit){const f=25.4;if("um"===unit)return this;{let s=new StatisticalVal;return s.min=this.min/f,s.max=this.max/f,s.sum=this.sum/f,s.avg=this.avg/f,s.var=this.var/Math.pow(f,2),s.dev=this.dev/f,s.n=this.n,s}},Batch.prototype.calculateStatistic=function(startIndexFe){let i,sFe=0,sNFe=0,sAll=0;for(i=0;i<this.m.length;i++)null!==this.m[i][startIndexFe]&&(sFe+=Math.pow(this.m[i][startIndexFe]-this.statFe.avg,2)),null!==this.m[i][startIndexFe+1]&&(sNFe+=Math.pow(this.m[i][startIndexFe+1]-this.statNFe.avg,2)),(null!==this.m[i][startIndexFe]&&null===this.m[i][startIndexFe+1]||null!==this.m[i][startIndexFe+1]&&null===this.m[i][startIndexFe])&&(sAll+=Math.pow(this.m[i][startIndexFe]-this.statAll.avg,2));this.statFe.n>1?(this.statFe.var=sFe/(this.statFe.n-1),this.statFe.dev=Math.sqrt(this.statFe.var)):(this.statFe.var=0,this.statFe.dev=0),this.statNFe.n>1?(this.statNFe.var=sNFe/(this.statNFe.n-1),this.statNFe.dev=Math.sqrt(this.statNFe.var)):(this.statNFe.var=0,this.statNFe.dev=0),this.statAll.n>1?(this.statAll.var=sAll/(this.statAll.n-1),this.statAll.dev=Math.sqrt(this.statAll.var)):(this.statAll.var=0,this.statAll.dev=0),9990===this.statFe.min&&(this.statFe.min=0),9990===this.statNFe.min&&(this.statNFe.min=0),9990===this.statAll.min&&(this.statAll.min=0)},Batch.prototype.splitMeasurements=function(mDataString){let pos=0,mDataArr=[],p1=-1,clearFlg=!1;do{"M"===mDataString.charAt(pos)?-1===p1?(p1=pos,pos+=23):(clearFlg||mDataArr.push(mDataString.substring(p1+2,pos)),p1=-1,clearFlg=!1):"X"===mDataString.charAt(pos)?-1===p1?(p1=pos,clearFlg=!0,pos+=23):(clearFlg||mDataArr.push(mDataString.substring(p1+2,pos)),p1=-1,clearFlg=!1):pos++}while(pos<=mDataString.length);return-1!==p1&&(clearFlg||mDataArr.push(mDataString.substring(p1+2,pos))),mDataArr},Batch.prototype.getMeasurements=function(unit){let fileData,factor="mil"===unit?25.4:1,filePath=Path.join(this.path_m,"MSMTS.DAT");try{fileData=fs.readFileSync(filePath,{encoding:"utf8"})}catch(err){return!1}let row,val1,val2,timeStamp1,timeStamp2,dt,subSec,isOk1,isOk2,tstMin,tstMax,fileRows=this.splitMeasurements(fileData),checkIsMinFlg=!1,checkIsMaxFlg=!1,checkIsMinSpotFlg=!1,checkIsMaxSpotFlg=!1;this.statFe.n=0,this.statNFe.n=0,this.statAll.n=0,this.statFe.sum=0,this.statNFe.sum=0,this.statAll.sum=0,this.statFe.min=9990,this.statNFe.min=9990,this.statAll.min=9990,this.spec.limits_rules_set_active&&(this.spec.area_upperlimit_active&&(checkIsMaxFlg=!0),this.spec.area_lowerlimit_active&&(checkIsMinFlg=!0),"limits.mrule_limits_off"!==this.spec.limits_rules_set_value&&"limits.mrule_simple_limits"!==this.spec.limits_rules_set_value&&(this.spec.spot_over_active&&(checkIsMaxSpotFlg=!0),this.spec.spot_under_active&&(checkIsMinSpotFlg=!0)));for(let idx=0;idx<fileRows.length;idx++)if(row=fileRows[idx].split(";"),4===row.length)if(val1=conv.convertIEEE754_32BitToFloat(parseInt(row[1],16)),dt=parseInt(row[2].substr(0,8),16),subSec=parseInt(row[2].substr(8,10),16),timeStamp1=conv.convertQnixTotime2DateSub(dt,subSec,TimeOffset),isOk1=!0,(checkIsMinFlg&&val1/factor<this.spec.area_lowerlimit_value||checkIsMaxFlg&&val1/factor>=this.spec.area_upperlimit_value)&&(isOk1=!1),tstMin=this.spec.spot_under_value/100*this.spec.area_lowerlimit_value,tstMax=this.spec.spot_over_value/100*this.spec.area_upperlimit_value,(checkIsMinSpotFlg&&val1/factor<tstMin||checkIsMaxSpotFlg&&val1/factor>=tstMax)&&(isOk1=!1),"01"===row[0])this.m.push([val1,null,timeStamp1,isOk1]),val1>this.statFe.max&&(this.statFe.max=val1),val1<this.statFe.min&&val1>0&&(this.statFe.min=val1),this.statFe.sum+=val1,this.statFe.n++,val1>this.statAll.max&&(this.statAll.max=val1),val1<this.statAll.min&&val1>0&&(this.statAll.min=val1),this.statAll.sum+=val1,this.statAll.n++;else{if("02"!==row[0])continue;this.m.push([null,val1,timeStamp1,isOk1]),val1>this.statNFe.max&&(this.statNFe.max=val1),val1<this.statNFe.min&&val1>0&&(this.statNFe.min=val1),this.statNFe.sum+=val1,this.statNFe.n++,val1>this.statAll.max&&(this.statAll.max=val1),val1<this.statAll.min&&val1>0&&(this.statAll.min=val1),this.statAll.sum+=val1,this.statAll.n++}else{if(7!==row.length)continue;"03"===row[0]?(val1=conv.convertIEEE754_32BitToFloat(parseInt(row[1],16)),dt=parseInt(row[2].substr(0,8),16),subSec=parseInt(row[2].substr(8,10),16),timeStamp1=conv.convertQnixTotime2DateSub(dt,subSec,TimeOffset),val2=conv.convertIEEE754_32BitToFloat(parseInt(row[4],16)),dt=parseInt(row[5].substr(0,8),16),subSec=parseInt(row[5].substr(8,10),16),timeStamp2=conv.convertQnixTotime2DateSub(dt,subSec,TimeOffset)):(val2=conv.convertIEEE754_32BitToFloat(parseInt(row[1],16)),dt=parseInt(row[2].substr(0,8),16),subSec=parseInt(row[2].substr(8,10),16),timeStamp2=conv.convertQnixTotime2DateSub(dt,subSec,TimeOffset),val1=conv.convertIEEE754_32BitToFloat(parseInt(row[4],16)),dt=parseInt(row[5].substr(0,8),16),subSec=parseInt(row[5].substr(8,10),16),timeStamp1=conv.convertQnixTotime2DateSub(dt,subSec,TimeOffset)),isOk1=!0,isOk2=!0,checkIsMinFlg&&val1/factor<this.spec.area_lowerlimit_value&&(isOk1=!1),checkIsMaxFlg&&val1/factor>=this.spec.area_upperlimit_value&&(isOk1=!1),checkIsMinFlg&&val2/factor<this.spec.area_lowerlimit_value&&(isOk2=!1),checkIsMaxFlg&&val2/factor>=this.spec.area_upperlimit_value&&(isOk2=!1),tstMin=this.spec.spot_under_value/100*this.spec.area_lowerlimit_value,tstMax=this.spec.spot_over_value/100*this.spec.area_upperlimit_value,checkIsMinSpotFlg&&val1/factor<tstMin&&(isOk1=!1),checkIsMaxSpotFlg&&val1/factor>=tstMax&&(isOk1=!1),checkIsMinSpotFlg&&val2/factor<tstMin&&(isOk2=!1),checkIsMaxSpotFlg&&val2/factor>=tstMax&&(isOk2=!1),("03"===row[0]&&"04"===row[3]||"04"===row[0]&&"03"===row[3])&&(val1>this.statFe.max&&(this.statFe.max=val1),val1<this.statFe.min&&val1>0&&(this.statFe.min=val1),this.statFe.sum+=val1,this.statFe.n++,val2>this.statNFe.max&&(this.statNFe.max=val2),val2<this.statNFe.min&&val2>0&&(this.statNFe.min=val2),this.statNFe.sum+=val2,this.statNFe.n++,timeStamp1>timeStamp2?this.m.push([val1,val2,timeStamp1,isOk1,isOk2]):this.m.push([val1,val2,timeStamp2,isOk1,isOk2]))}return this.statFe.n>0&&(this.statFe.avg=this.statFe.sum/this.statFe.n),this.statNFe.n>0&&(this.statNFe.avg=this.statNFe.sum/this.statNFe.n),this.statAll.n>0&&(this.statAll.avg=this.statAll.sum/this.statAll.n),!0},Batch.prototype.getNumberMeasurements=function(){let fileData,filePath=Path.join(this.path_m,"MSMTS.DAT");try{fileData=fs.readFileSync(filePath,"utf8")}catch(err){return void(this.count=0)}let fileRows=fileData.split("M;");this.count=fileRows.length-1},Batch.prototype.convertMeasurementsUnit=function(unit){let convM=new Array(this.m.length);if("um"===unit)return this.m;for(let idx=0;idx<this.m.length;idx++)convM[idx]=new Array(this.m[idx].length),convM[idx][0]=null!==this.m[idx][0]?this.m[idx][0]/25.4:null,convM[idx][1]=null!==this.m[idx][1]?this.m[idx][1]/25.4:null,convM[idx][2]=null!==convM[idx][0]||null!==convM[idx][1]?this.m[idx][2]:null,convM[idx][3]=this.m[idx][3],5===convM[idx].length&&(convM[idx][4]=this.m[idx][4]);return convM},Batch.prototype.convertStatisticsUnit=function(unit){if("um"===unit)return[this.statFe,this.statNFe,this.statAll];return[this.statFe.convert(unit),this.statNFe.convert(unit),this.statAll.convert(unit)]},Batch.prototype.getBatchName=function(filePath){let infoFile="";try{infoFile=fs.readJsonSync(Path.join(filePath,NameFile)),this.name=infoFile.name}catch(error){console.error("error - can not read info.jsn : "+filePath+"/info.jsn"),this.name=ErrorFile_Info.name;try{return fs.writeJsonSync(Path.join(filePath,NameFile),ErrorFile_Info),console.log("write new INFO.JSN in Area"),!1}catch(error){return console.error("fatal error - can't write new info.jsn in area to fix error : "+path),this.name="?error?",!0}}return!1},Batch.prototype.getLimits=function(filePath,unit){try{this.spec=fs.readJsonSync(Path.join(filePath,LimitFile)),"um"!==unit&&(this.spec.area_upperlimit_value/=25.4,this.spec.area_lowerlimit_value/=25.4)}catch(error){return console.info("error - can not read limits.jsn : "+filePath+"\\info.jsn"),!0}return!1},Batch.prototype.writeNewBatch=function(){try{fs.accessSync(Path.join(this.path_m),fs.constants.R_OK|fs.constants.W_OK)}catch(error){fs.mkdirSync(Path.join(this.path_m))}try{fs.writeJsonSync(Path.join(this.path_m,NameFile),{name:this.name}),fs.writeJsonSync(Path.join(this.path_m,LimitFile),this.spec)}catch(error){return console.info("error - can not save new batch name/limits"),!0}if(this.count>0&&this.m.length>0){let tmpArr,t,data="";for(let mIdx=0;mIdx<this.m.length;mIdx++)null!==this.m[mIdx]&&(data+="M;",null!==this.m[mIdx][0]&&null===this.m[mIdx][1]?(tmpArr=conv.convertFloatToIEEE754Arr(this.m[mIdx][0]),data+="01;"+conv.formatHexStr(conv.convertToArr32Bit(tmpArr).toString(16),8)+";",t=conv.convertDateSubToQnix_timeHex(new Date(this.m[mIdx][2])),data+=t+";\n"):null===this.m[mIdx][0]&&null!==this.m[mIdx][1]?(tmpArr=conv.convertFloatToIEEE754Arr(this.m[mIdx][1]),data+="02;"+conv.formatHexStr(conv.convertToArr32Bit(tmpArr).toString(16),8)+";",t=conv.convertDateSubToQnix_timeHex(new Date(this.m[mIdx][2])),data+=t+";\n"):null!==this.m[mIdx][0]&&null!==this.m[mIdx][1]&&(tmpArr=conv.convertFloatToIEEE754Arr(this.m[mIdx][0]),data+="03;"+conv.formatHexStr(conv.convertToArr32Bit(tmpArr).toString(16),8)+";",t=conv.convertDateSubToQnix_timeHex(new Date(this.m[mIdx][2])),data+=t+";",tmpArr=conv.convertFloatToIEEE754Arr(this.m[mIdx][1]),data+="04;"+conv.formatHexStr(conv.convertToArr32Bit(tmpArr).toString(16),8)+";",data+=t+";\n"));fs.writeFileSync(Path.join(this.path_m,"MSMTS.DAT"),data)}else DeleteFileOrFolder(Path.join(this.path_m,"MSMTS.DAT"));return!1},BatchDirectory.prototype.getBatch=function(filename,unit){let pathDataFile=Path.join(this.path,filename),b=new Batch;return b.path_m=filename,b.fileIndex=parseInt(filename.substr(4,4),16),!!b.getBatchName(pathDataFile)||(b.getLimits(pathDataFile,unit)?(this.list.push(b),!0):(this.list.push(b),!1))},BatchDirectory.prototype.getBatchList=function(unit){let fList,fname,dir;try{fList=fs.readdirSync(this.path),dir=new Directory,dir.Path=this.path,dir.readHeader(),this.name=dir.Name}catch(err){return void console.info(" error - reading job directory")}for(let idx=0;idx<fList.length;idx++)fname=Path.basename(fList[idx]),null!==fname.match("AREA[0-9,A-F,a-f]{4}")&&this.getBatch(fname,unit)},BatchDirectory.prototype.nextFreeBatchFile=function(){let tst,name;if(0!==this.list.length)for(let idx=1;idx<65535;idx++){tst=!1;for(let i=0;i<this.list.length;i++)if(!(this.list[i].fileIndex<idx)&&idx===this.list[i].fileIndex){tst=!0;break}if(!tst){name="AREA"+conv.index2HexString(idx);break}}else name="AREA0001";return name},BatchDirectory.prototype.nextBatchFile=function(){let name;if(0!==this.list.length){let maxIdx=1;for(let i=0;i<this.list.length;i++)void 0!==this.list[i].fileIndex&&this.list[i].fileIndex>maxIdx&&(maxIdx=this.list[i].fileIndex);name="AREA"+conv.index2HexString(maxIdx+1)}else name="AREA0001";return name},BatchDirectory.prototype.delAllBatches=function(){let fpath;for(let idx=0;idx<this.list.length;idx++)fpath=Path.join(this.path,"AREA"+conv.index2HexString(this.list[idx].fileIndex)),console.log("delete batch "+fpath),fs.removeSync(fpath);this.list=[]},BatchDirectory.prototype.loadAllBatchesMeasurements=function(unit){let okFlg,stat;console.log("Start loadAllBatchesMeasurements...");for(let count=0;count<this.list.length;count++)okFlg=this.list[count].getMeasurements(unit),okFlg&&(this.list[count].calculateStatistic(0),stat=this.list[count].convertStatisticsUnit(unit),this.list[count].m=this.list[count].convertMeasurementsUnit(unit),this.list[count].statFe=stat[0],this.list[count].statNFe=stat[1],this.list[count].statAll=stat[2],this.list[count].convertStatisticsUnit(unit));console.log("End loadAllBatchesMeasurements")},BatchDirectory.prototype.countAllBatchesMeasurements=function(){this.count=0;for(let count=0;count<this.list.length;count++){let batchName="AREA"+conv.index2HexString(this.list[count].fileIndex);this.list[count].path_m=Path.join(this.path,batchName),this.list[count].getNumberMeasurements(),this.count+=this.list[count].count}},BatchDirectory.prototype.createNewEmptyBatches=function(batchLst){if(0===batchLst.length)console.info("no batches to create");else{let batchDir,infoFile,limitFile,bIdx,i;for(let idx=0;idx<batchLst.length;idx++){for(bIdx=(batchLst.length-idx).toString(16).toUpperCase(),i=bIdx.length;i<4;i++)bIdx="0"+bIdx;batchDir="AREA"+bIdx,batchDir=Path.join(this.path,batchDir),fs.mkdirSync(batchDir),infoFile=Path.join(batchDir,NameFile),limitFile=Path.join(batchDir,LimitFile),fs.writeJsonSync(infoFile,{name:batchLst[idx].name}),fs.writeJsonSync(limitFile,batchLst[idx].spec)}}};let getJob=function(mode,path,unit,funcDataHandler){let list=getDirectoryList(PathList.QN8job);job=null;for(let jobIdx=0;jobIdx<list.length;jobIdx++)if("job"===list[jobIdx].Type&&list[jobIdx].Path===path){job=new BatchDirectory(list[jobIdx].Path),job.name=list[jobIdx].Name,job.getBatchList(unit),job.countAllBatchesMeasurements(),job.loadAllBatchesMeasurements(unit),funcDataHandler(job.list);break}};module.exports={setReportLang(lang,company){let toolboxPath=Path.join(Path.dirname(__dirname),"data",company);fs.readdir(toolboxPath,(function(err,list){let pathToolbox,findFlg=!1;if(err)console.error("error - can't reading toolbox files (path problem)");else{for(let i=0;i<list.length;i++)if(list[i].toUpperCase()===lang){findFlg=!0;break}findFlg||(console.info("Report language : "+lang+" is not supported"),lang="ENG"),pathToolbox=Path.join(toolboxPath,lang).replace(/\\/g,"/"),PathList.currentQN8Toolbox=pathToolbox,reportToolbox.loadToolbox(),console.log("Report language : "+lang+" is used")}}))},setPathTemplateReport(p){PathList.QN8templateReport=p},setPathTemplateJob(p){PathList.QN8templateJob=p},setPathJob(p){PathList.QN8job=p},setPathReport(p){PathList.QN8report=p},getPathList:()=>PathList,saveAllPath:SaveAllPath,getDirectoryListQN8(){let lst1=getDirectoryList(PathList.QN8templateReport),lst2=getDirectoryList(PathList.QN8templateJob),lst3=getDirectoryList(PathList.QN8report),lst4=getDirectoryList(PathList.QN8job);return lst1.concat(lst2,lst3,lst4)},getDirectoryListHG(){let lst1=getDirectoryList(PathList.currentHGtemplateReport),lst2=getDirectoryList(PathList.currentHGtemplateJob),lst3=getDirectoryList(PathList.currentHGreport),lst4=getDirectoryList(PathList.currentHGjob);return lst1.concat(lst2,lst3,lst4)},getPartDirectoryListQN8(){let lst1=getDirectoryList(PathList.QN8templateReport),lst2=getDirectoryList(PathList.QN8templateJob),lst3=getDirectoryList(PathList.QN8report);return{job:getDirectoryList(PathList.QN8job),templateJob:lst2,templateReport:lst1,report:lst3}},getPartDirectoryListHG(){let lst1=getDirectoryList(PathList.currentHGtemplateReport),lst2=getDirectoryList(PathList.currentHGtemplateJob),lst3=getDirectoryList(PathList.currentHGreport);return{job:getDirectoryList(PathList.currentHGjob),templateJob:lst2,templateReport:lst1,report:lst3}},getReportTemplateList(){let fullList=getDirectoryList(PathList.QN8templateReport),lst=[];for(let i=0;i<fullList.length;i++)lst.push({name:fullList[i].Name,readonly:fullList[i].Readonly});return lst},nextFreeFolder:NextFreeFolder,copyFolder:copyFolder,copyFile(source,direction){let destPath=direction?PathList.QN8report:PathList.currentHGreport;destPath=Path.join(destPath,Path.basename(source));try{fs.copySync(source,destPath),console.log("COPY FILE "+source+" -> "+Path.join(destPath,Path.basename(source)))}catch(err){console.info("Error - file copy "+source+" -> "+destPath),destPath=""}return destPath},copyFileWithNewName(source,destName,direction){let destPath=direction?PathList.QN8report:PathList.currentHGreport;destPath=Path.join(destPath,destName);try{fs.copySync(source,destPath),console.log("COPY FILE "+source+" -> "+destPath)}catch(err){console.info("Error - file copy "+source+" -> "+destPath),destPath=""}return destPath},setNewName(find){find.writeHeader(),console.log("SET NEW NAME "+find.Path+" Name="+find.Name)},renameFile(directory,name){let newPath=Path.join(Path.dirname(directory.Path),name);try{fs.renameSync(directory.Path,newPath),console.log("RENAME "+directory.Path+" -> "+newPath)}catch(error){newPath="",console.log("Error - rename file "+directory.Path+" -> "+newPath)}return newPath},deleteFileOrFolder:DeleteFileOrFolder,getFolderName:path=>Path.basename(path),deleteDirectoryElement(lst,search_path){let lst1,lst2="";for(let i=0;i<lst.length;i++)if(search_path===lst[i].Path){lst1=lst.slice(0,i),i+1!==lst.length&&(lst2=lst.slice(i+1,lst.length)),lst=lst1.concat(lst2);break}return lst},generateBackupName(find,destList){let findCol,newName=(find.Name+"(1)").toString(),backupIdx=1,loop=!0;for(;loop;){findCol=!1;for(let i=0;i<destList.length;i++)if(destList[i].Name===newName){findCol=!0;break}findCol?newName=find.Name+"("+backupIdx+++")":loop=!1}return newName},newTemplateReport(currentName,name,elements,readonly){let fileIdx,elemIdx,paramIdx,findFlg,fName,imagePath,newTemplateReport=new Directory,destList=getDirectoryList(PathList.QN8templateReport),newFolderName=NextFreeFolder(destList,"RT");newTemplateReport.Path=Path.join(PathList.QN8templateReport,newFolderName),newTemplateReport.Name=name,newTemplateReport.Type="rept",newTemplateReport.Readonly=readonly;try{fs.mkdirSync(newTemplateReport.Path),newTemplateReport.writeHeader()}catch(error){return void console.info("Error - creating error : new folder for template report")}for(elemIdx=0;elemIdx<elements.length;elemIdx++)if(elements[elemIdx].id>=80&&elements[elemIdx].id<90)for(paramIdx=0;paramIdx<elements[elemIdx].content.length;paramIdx++)if(imagePath=elements[elemIdx].imgPath[paramIdx],""!==imagePath)fName=importImgFile(newTemplateReport.Path,imagePath),""===fName?console.error("error - copy of a new image to a report template folder"):(elements[elemIdx].imgPath[paramIdx]="",elements[elemIdx].content[paramIdx]=fName);else{for(findFlg=!1,fileIdx=0;fileIdx<destList.length;fileIdx++)if(destList[fileIdx].Name===currentName){findFlg=!0,imagePath=Path.join(destList[fileIdx].Path,elements[elemIdx].content[paramIdx]),fName=importImgFile(newTemplateReport.Path,imagePath),""===fName&&console.error("error - copy of a image to a report template folder");break}findFlg||console.error("error - image not exist (report template folder)")}else elements[elemIdx].id===EnumReportElementType.textblock_adr&&(paramIdx=elements[elemIdx].content.length-1,imagePath=elements[elemIdx].imgPath[paramIdx],void 0!==imagePath&&""!==imagePath?(fName=importImgFile(newTemplateReport.Path,imagePath),""===fName?console.error("error - copy of a image to a report template folder"):(elements[elemIdx].imgPath[paramIdx]="",elements[elemIdx].content[paramIdx]=fName)):(imagePath=elements[elemIdx].content[4],void 0!==imagePath&&""!==imagePath&&(imagePath=Path.join(currentTemplateReport.path,imagePath),fName=importImgFile(newTemplateReport.Path,imagePath),""===fName&&console.error("error - copy of a image"))));return newTemplateReport.Elements=elements,newTemplateReport.writeStruct(),console.log("new report template is generated"),currentTemplateReport.name=name,currentTemplateReport.path=newTemplateReport.Path,elements},overwriteReportOrReportTemplate(name,elements,readonly,type,jobName){let elemIdx,paramIdx,fName,imagePath,entry,i,findFlg,reportPath=type?PathList.QN8report:PathList.QN8templateReport,list=fs.readdirSync(reportPath),oldImage=[];for(i=0;i<list.length;i++)if(entry=new Directory,entry.getType(Path.join(reportPath,list[i])),"undefined"!==entry.Type&&"unknown"!==entry.Type&&entry.Name===name){let filePath=Path.join(entry.Path,"struct.json");for(console.log("Report-Vorlage: "+filePath+" überschreiben"),elemIdx=0;elemIdx<elements.length;elemIdx++)if(elements[elemIdx].id>=80&&elements[elemIdx].id<90)for(paramIdx=0;paramIdx<elements[elemIdx].content.length;paramIdx++)imagePath=elements[elemIdx].imgPath[paramIdx],""!==imagePath&&(fName=importImgFile(entry.Path,imagePath),""===fName?console.error("error - copy of a image to a report template folder"):(elements[elemIdx].imgPath[paramIdx]="",""!==elements[elemIdx].content[paramIdx]&&oldImage.push(elements[elemIdx].content[paramIdx]),elements[elemIdx].content[paramIdx]=fName));else elements[elemIdx].id===EnumReportElementType.textblock_adr&&(paramIdx=elements[elemIdx].content.length-1,imagePath=elements[elemIdx].imgPath[paramIdx],void 0!==imagePath&&""!==imagePath&&(fName=importImgFile(entry.Path,imagePath),""===fName?console.error("error - copy of a image to a report template folder"):(elements[elemIdx].imgPath[paramIdx]="",""!==elements[elemIdx].content[paramIdx]&&oldImage.push(elements[elemIdx].content[paramIdx]),elements[elemIdx].content[paramIdx]=fName)));console.log("filename = "+filePath);try{type?fs.writeJsonSync(filePath,{elements:elements}):fs.writeJsonSync(filePath,{elements:elements,readonly:readonly})}catch(err){console.error("error - overwrite file report template struct.json")}}for(i=0;i<oldImage.length;i++)for(findFlg=!1,elemIdx=0;elemIdx<elements.length;elemIdx++){if(elements[elemIdx].id>=80&&elements[elemIdx].id<90)for(paramIdx=0;paramIdx<elements[elemIdx].content.length;paramIdx++)if(oldImage[i]===elements[elemIdx].content[paramIdx]){oldImage[i]="",findFlg=!0;break}if(findFlg)break}let funcDeleteFile=function(err){err?console.error("error - unused image "+imagePath+" couldn't be deleted"):console.log("ok - image "+imagePath+" deleted")};for(i=0;i<oldImage.length;i++)""!==oldImage[i]&&(imagePath=Path.join(entry.Path,oldImage[i]),fs.unlink(imagePath,funcDeleteFile),console.info(" delete image "+imagePath));return elements},deleteTemplateReport(name){let list=getDirectoryList(PathList.QN8templateReport),errFlg=!0;for(let i=0;i<list.length;i++)if(list[i].Name===name){errFlg=DeleteFileOrFolder(list[i].Path),currentTemplateReport.name="",currentTemplateReport.path="";break}return errFlg},deleteJobTemplate(name,type){let list,errFlg=!1;switch(type){case"job":list=getDirectoryList(PathList.QN8job);break;case"jobt":list=getDirectoryList(PathList.QN8templateJob);break;default:errFlg=!0}for(let i=0;i<list.length;i++)if(list[i].Name===name&&list[i].Type===type){errFlg=DeleteFileOrFolder(list[i].Path),currentTemplateReport.name="",currentTemplateReport.path="";break}return errFlg},getLangList(fileFlg){let languageFilePath;languageFilePath=fileFlg?Path.join(Path.dirname(__dirname),"public","Locale","langGauge.json"):Path.join(Path.dirname(__dirname),"public","Locale","lang.json");let list=fs.readJsonSync(languageFilePath);return list.length<1?(console.error("error - language list file error!"),null):list},getToolbox:()=>(0===reportToolbox.list.length&&reportToolbox.loadToolbox(),reportToolbox.list),getTemplateReport(name){let content,structPath,list=getDirectoryList(PathList.QN8templateReport);for(let i=0;i<list.length;i++)if("rept"===list[i].Type&&list[i].Name===name){currentTemplateReport.path=list[i].Path,structPath=Path.join(list[i].Path,"struct.json"),currentTemplateReport.name=name;try{content=fs.readJsonSync(structPath)}catch(err){return console.error("error - file read report template struct"),""}return content}},getImage(name,report,type,company){let data;switch(console.info("Function getImage, name="+name+" type="+type+" report="+report),type){case"RT":data="imgReport/example.jpg"===name?Path.join(__dirname,"../","public","imgReport","example.jpg"):Path.join(currentTemplateReport.path,name);try{data=fs.readFileSync(data)}catch(err){console.error("error - read image report template"),data=""}break;case"R_":let content,i,list=getDirectoryList(PathList.QN8report);for(i=0;i<list.length;i++)if("rep"===list[i].Type&&list[i].Name===report){data=""===name?Path.join(__dirname,"..\\public\\imgReport\\no_image.png"):Path.join(list[i].Path,name);try{content=fs.readFileSync(data)}catch(err){return console.error("error - read image report"),""}return content}data="";break;case"Logo":name=Path.join(Path.dirname(__dirname),"data",company,"Logo.jpg"),data=fs.readFileSync(name);break;case"Path":let pathFile;pathFile="."===name.charAt(0)?Path.join(Path.dirname(__dirname),name):name,data=fs.readFileSync(pathFile);break;default:console.error("error - unknown data type (working directory) for images"),data=""}return data},getJobList(){let i,jobList=getDirectoryList(PathList.QN8job),lst=[];for(i=0;i<jobList.length;i++)"job"===jobList[i].Type&&(jobList[i].QN8flg=!0,lst.push(jobList[i]));return lst},getReportList(){let repList=getDirectoryList(PathList.QN8report),lst=[];for(let i=0;i<repList.length;i++)"rep"===repList[i].Type&&lst.push(repList[i].Name);return lst},getReportPreview(name){let content,structPath,entry,reportPath=PathList.QN8report,list=fs.readdirSync(reportPath);for(let i=0;i<list.length;i++)if(entry=new Directory,entry.getType(Path.join(reportPath,list[i])),"undefined"!==entry.Type&&"unknown"!==entry.Type&&entry.Name===name&&"rep"===entry.Type){structPath=Path.join(entry.Path,"struct.json");try{content=fs.readJsonSync(structPath)}catch(err){return console.error("error - file read report struct"),""}return content}},getReport(name,asiaFlg,unit,pageformat,resultFkt){let content,structPath,entry,reportPath=PathList.QN8report,list=fs.readdirSync(reportPath),report={},resultFunc=function(errFlg,pageNo){report.batches=[],report.numberPages=pageNo,resultFkt(errFlg,report)};for(let i=0;i<list.length;i++)if(entry=new Directory,entry.getType(Path.join(reportPath,list[i])),"undefined"!==entry.Type&&"unknown"!==entry.Type&&entry.Name===name&&"rep"===entry.Type){structPath=Path.join(entry.Path,"struct.json");try{content=fs.readJsonSync(structPath)}catch(err){return console.error("error - file read report struct"),""}return job=new BatchDirectory(Path.join(entry.Path,"JOB0001")),job.getBatchList(unit),job.countAllBatchesMeasurements(),job.loadAllBatchesMeasurements(unit),report.unit=unit,report.type="rep",report.name=name,report.pageformat=pageformat,report.elements=content.elements,report.batches=job.list,report.asiaFlg=asiaFlg,report.jobName=job.name,report.count=job.count,report.jobPath=job.path,void buildHTMLReport(!0,report,resultFunc)}resultFkt(!0,{})},newReport(name,elements,templateName,jobPath,sourceName,allAreasFlg,areas){let newReport=new Directory,destList=getDirectoryList(PathList.QN8report),newFolderName=NextFreeFolder(destList,"R_");newReport.Path=Path.join(PathList.QN8report,newFolderName),newReport.Name=name,newReport.Type="rep",newReport.Readonly=!1,newReport.Elements=elements;try{fs.mkdirSync(newReport.Path),newReport.writeHeader()}catch(error){return console.error("Error - creating error : new folder for report"),null}return newReport.writeStruct(),newReport.copyReportFiles(templateName,sourceName,jobPath,allAreasFlg,areas),console.log("new report is generated"),newReport.Elements},deleteFiles(delList){let errFlg=!1;for(let idx=0;idx<delList.length;idx++)console.log("to delete "+delList[idx].Name+" "+delList[idx].Path),DeleteFileOrFolder(delList[idx].Path)?errFlg=!0:console.log("deleted "+delList[idx].Name+" "+delList[idx].Path);return errFlg},startTV:generation.startTV,makePDF(socket,PDFName,pageFormat,pageNumbers,HTMLReportName,resFunc){null!==job&&job.count>25e4?resFunc(new Error("maxreadings")):parseInt(pageNumbers)>2500?resFunc(new Error("maxpages")):null!==job&&job.list.length>100?resFunc(new Error("maxareas")):generation.makePDF(socket,PDFName,pageFormat,HTMLReportName,PathList,resFunc)},makeCertPDF(pathFile,resultFunc){generation.makeCertificatePDF(pathFile,resultFunc)},buildHTMLReport:buildHTMLReport,writeHTMLPage(page,format,asiaFlg,resultFunc){fs.readFile(TempFileReport,"utf8",(function(err,data){let contentHTML;if(err)resultFunc(err);else{let posEnd,pageData,envelopeData=getStartAndEndHtmlSections("true"===asiaFlg,format),posStart=0;for(let pageNo=1;pageNo<=page;pageNo++)if(posStart=data.indexOf("<div class='page_area'>",posStart+22),-1===posStart)return console.info("writeHTMLPage() : page not found"),void resultFunc(!1);if(posEnd=data.indexOf("</footer>",posStart+22),-1===posEnd)return console.info("writeHTMLPage() error : page end not found"),void resultFunc(!0);if(posEnd+21>data.length)return void resultFunc(!0);pageData=envelopeData.start,contentHTML=data.substring(posStart,posEnd+21);let idx1=contentHTML.indexOf("mDataH[");if(idx1>0){let idx2=contentHTML.indexOf("=",idx1),idx=contentHTML.substring(idx1+7,idx2-2);idx.length>0&&(pageData=pageData.replace("chartInfoH","chartInfoH="+idx))}pageData+=contentHTML,pageData+=envelopeData.end,fs.writeFile(TempFilePreviewPage,pageData,(function(err){resultFunc(!!err)}))}}))},getPdfPath:()=>PathList.currentPdfPath,getJobTemplateList(){let jobList=getDirectoryList(PathList.QN8templateJob),lst=[];for(let i=0;i<jobList.length;i++)"jobt"===jobList[i].Type&&lst.push(jobList[i].Name);return lst},writeJobTemplate(name,batches,unit){let jobTemplateList=getDirectoryList(PathList.QN8templateJob);for(let idx=0;idx<batches.length;idx++)try{delete batches[idx].spec.input_mask}catch(err){}for(let i=0;i<jobTemplateList.length;i++)if(name===jobTemplateList[i].Name&&"jobt"===jobTemplateList[i].Type)return console.log("overwriteJob()"),void overwriteJob(jobTemplateList[i].Path,batches,unit);console.log("newJobTemplate()"),newJobTemplate(jobTemplateList,name,batches,unit)},writeJob(name,batches,unit){let file,batchFile,batch,errFlag=!1;for(let idx=0;idx<batches.length;idx++)try{delete batches[idx].spec.input_mask}catch(err){}name!==job.name&&(job.name=name,file=Path.join(job.path,NameFile),fs.writeJsonSync(file,{name:job.name}));for(let idx=0;idx<batches.length;idx++)null===batches[idx]?(file=job.list[batches.length-idx-1].path_m,DeleteFileOrFolder(file)&&console.info("error - delete batch ")):(batch=new Batch,void 0===batches[idx].fileIndex?(console.log("  new batch : "+file),batchFile=job.nextBatchFile(),file=Path.join(job.path,batchFile),batch.name=batches[idx].name,batch.count=batches[idx].count,batch.fileIndex=parseInt(batchFile.substring(5,file.length),16),batch.path_m=file,batch.spec=batches[idx].spec,void 0!==batches[idx].m&&(batch.m=JSON.parse(JSON.stringify(batches[idx].m))),job.list.push(batch),errFlag=batch.writeNewBatch()):(batchFile="AREA"+conv.index2HexString(batches[idx].fileIndex.toString(16)),file=Path.join(job.path,batchFile),batch.name=batches[idx].name,batch.count=batches[idx].count,batch.fileIndex=parseInt(batchFile.substring(5,file.length),16),batch.path_m=file,0===batches[idx].m.length?(batch.spec=batches[idx].spec,0===batches[idx].count?(batch.m=[],job.list[batches.length-idx-1].m=[]):batch.m=JSON.parse(JSON.stringify(job.list[batches.length-idx-1].m))):(batch.spec=batches[idx].spec,batch.m=JSON.parse(JSON.stringify(batches[idx].m)),job.list[batches.length-idx-1]=batch),errFlag=batch.writeNewBatch()));return errFlag},writeNewJob(name,batch,unit,resultFunc){let area,newJob=new Directory,destList=getDirectoryList(PathList.QN8job),newFolderName=NextFreeFolder(destList,"JOB");newJob.Path=Path.join(PathList.QN8job,newFolderName),newJob.Name=name,newJob.Type="job";try{fs.mkdirSync(newJob.Path),newJob.writeHeader()}catch(error){return console.error("Error - creating error : new folder for job"),void resultFunc(!0)}for(let idx=0;idx<batch.length;idx++)area=new Batch,area.path_m=Path.join(newJob.Path,"AREA"+conv.index2HexString(batch.length-idx)),area.name=batch[idx].name,area.spec=batch[idx].spec,area.m=batch[idx].m,area.count=batch[idx].m.length,area.writeNewBatch();resultFunc(!1)},clearBatch(path,unit,funcDataHandler){console.log("clearBatch()"),path.length>0&&null!==job&&(job.list=[],DeleteFileOrFolder(path),job.getBatchList(unit),job.countAllBatchesMeasurements(),funcDataHandler(job.list),job.loadAllBatchesMeasurements(unit))},getJobTemplate(name,unit,funcTemplateDataHandler){let list=getDirectoryList(PathList.QN8templateJob);for(let i=0;i<list.length;i++)if(("job"===list[i].Type||"jobt"===list[i].Type)&&list[i].Name===name){let batchLst=new BatchDirectory(list[i].Path);batchLst.name=name,batchLst.getBatchList(unit),funcTemplateDataHandler(batchLst.list);break}},getJob:getJob,addBatch(jobPath,unit,batch,resultFunc){job=new BatchDirectory(jobPath),job.getBatchList(unit);let b=new Batch;b.name=batch.name,b.spec=batch.spec,b.m=batch.m,b.count=batch.m.length,b.path_m=Path.join(jobPath,job.nextFreeBatchFile()),resultFunc(b.writeNewBatch())},getBatch(path){for(let batchIdx=0;batchIdx<job.list.length;batchIdx++)if(job.list[batchIdx].path_m===path){let batch=new Batch;return batch.m=job.list[batchIdx].m,batch.statFe=job.list[batchIdx].statFe,batch.statNFe=job.list[batchIdx].statNFe,batch.statAll=job.list[batchIdx].statAll,batch.count=job.list[batchIdx].count,batch.isEmpty=!1,batch}return null},getAllBatches(){let fe,nfe,currentBatch,sd,sub,allBatches=new Batch;allBatches.statFe.min=9990,allBatches.statNFe.min=9990,allBatches.statAll.min=9990,allBatches.m_chart=[];for(let batchIdx=0;batchIdx<job.list.length;batchIdx++){currentBatch=new Batch,currentBatch=job.list[batchIdx],currentBatch.statFe.n>0&&0===currentBatch.statNFe.n?(sd=currentBatch.statFe.avg,sub=0):currentBatch.statNFe.n>0&&0===currentBatch.statFe.n?(sd=currentBatch.statNFe.avg,sub=1):currentBatch.statFe.n>0&&currentBatch.statNFe.n>0?(sd=currentBatch.statFe.avg>currentBatch.statNFe.avg?currentBatch.statFe.avg:currentBatch.statNFe.avg,sub=2):(sd=0,sub=0),allBatches.m_chart.push([currentBatch.name,sd,sub]);for(let i=0;i<currentBatch.count;i++)fe=currentBatch.m[i][0],nfe=currentBatch.m[i][1],allBatches.m.push([job.list[batchIdx].name,fe,nfe,currentBatch.m[i][2]]),null!==fe&&(allBatches.statFe.sum+=fe,allBatches.statFe.n++,null===nfe&&(allBatches.statAll.avg+=fe,allBatches.statAll.n++),fe>allBatches.statFe.max&&(allBatches.statFe.max=fe),fe>allBatches.statAll.max&&(allBatches.statAll.max=fe),fe<allBatches.statFe.min&&(allBatches.statFe.min=fe),fe<allBatches.statAll.min&&(allBatches.statAll.min=fe)),null!==nfe&&(allBatches.statNFe.sum+=nfe,allBatches.statNFe.n++,null===fe&&(allBatches.statAll.avg+=nfe,allBatches.statAll.n++),nfe>allBatches.statNFe.max&&(allBatches.statNFe.max=nfe),nfe>allBatches.statAll.max&&(allBatches.statAll.max=nfe),nfe<allBatches.statNFe.min&&(allBatches.statNFe.min=nfe),nfe<allBatches.statAll.min&&(allBatches.statAll.min=nfe))}return allBatches.statFe.n>0&&(allBatches.statFe.avg=allBatches.statFe.sum/allBatches.statFe.n),allBatches.statNFe.n>0&&(allBatches.statNFe.avg=allBatches.statNFe.sum/allBatches.statNFe.n),allBatches.statAll.avg>0&&(allBatches.statAll.avg/=allBatches.statAll.n),allBatches.calculateStatistic(1),allBatches},getGaugeSettingsPathFile(){let path="";return""!==PathList.HG_drive&&(path=Path.join(PathList.currentHGsystem,"USER.JSN")),path},getProbeSettingsPathFile(){let path="";return""!==PathList.HG_drive&&(path=Path.join(PathList.currentHGsystem,"PROBE.JSN")),path},getLimitSettingsPathFile(){let path="";return""!==PathList.HG_drive&&(path=Path.join(PathList.currentHGsystem,LimitFile)),path},getJustSettingsPathFile(){let path="";return""!==PathList.HG_drive&&(path=Path.join(PathList.currentHGsystem,"ADJUST.JSN")),path},writeXLSX(name,unit,langText,returnFunc){generation.generateXLSX(name,unit,langText,PathList.QN8report,job.list,returnFunc)},saveJobAsTemplate(name,unit){let jobTemplateList=getDirectoryList(PathList.QN8templateJob);newJobTemplate(jobTemplateList,name,job.list,unit)},getRecoveryPaths:()=>({source:Path.join(__dirname,"../","data","Recovery1"),dest:PathList.HG_drive}),setDrive(drive,name,port){console.log("setDrive: drive = "+drive+"  name = "+name+"  COM-Port = "+port),PathList.HG_drive=drive,PathList.HG_name=name,PathList.HG_COM=port,PathList=BuildGaugePath(PathList)},saveDeviceJobFile:saveDeviceJobFile,getVersion(){let pathPackageJS=Path.join(__dirname,"../","package.json");try{return fs.readJsonSync(pathPackageJS).version}catch(error){return console.error("error - read package.json"),"?"}},createDirectory(name,path,type){let dir=new Directory;return dir.Name=name,dir.Path=path,dir.Type=type,dir},setTimeOffset(offset){TimeOffset=offset,console.log("applicationLayer setTimeOffset")}},fs.existsSync(pathFilePath)?fs.readJson(pathFilePath,(function(err,list){null!==err?console.info("error - read path.json, not exist "):PathList=list,PathList.ConfigPath!==pathFilePath&&(console.info("path.json must be delete, new installation!"),fs.remove(pathFilePath,(function(err){err?console.err("error - can't delete old file path.json "):generateNewPathFile()})))})):generateNewPathFile(),module.exports.getVersion();