"use strict";console.info("Modul applicationLayer loading...");let Sockets,applicationLayer,fs=require("fs"),UTF8=require("utf-8"),conv=require("./convert.js"),TimeOffset=0;function Measuremode(){this.mtype=0,this.time=0,this.rangehigh=0,this.rangelow=0}class ApplicationData{constructor(){this.mwtype={reserved:0,sd_fe:1,sd_nfe:2,duplexFe:3,duplexNFe:4,autoSub:5,duplex:7,probeConnected:129,probeDisconnected:130,ntc:239,uh_ic:240,uh_ur:241,coil0:242,coil1:243,coil2:244,coil3:245},this.vartype={ROTATION:1,AUTO_BRIGHTNESS:2,BRIGHTNESS:3,BUZZER_VOLUME:4,BUTTON_BEEP:5,PIN:6,LANGUAGE:7,DESIGN:8,UNIT:9,RESOLUTION:10,DISPLAY_TIMEOUT:11,POWER_TIMEOUT:12,SOFTKEY_ACTION:13,ANALYSIS_SCREEN:14,ANALYSIS_STATISTICS:15,USER_CAL_DATE:128,LIMITS:129,MEASURE_INTERVAL:130,TRIGGER_MODE:131,CURRENT_MODE:132,FE_BASE_ADJUST:133,NFE_INFI_COUNT:134,NFE_ZERO_COUNT:135,FE_OFFSET:136,NFE_OFFSET:137,FE_ADJUST:138,NFE_ADJUST:139,DEVICE_VARIANT:256,SERIAL_NUMBER:257,DEVICE_NAME:258,INITIALIZED_FLAG:259,PRODUCT_KEY:260,MAX_JOB_COUNT:272,MAX_AREA_COUNT:273,MAX_SPOT_COUNT:274,MEASURE_MODES:288,FE_CALIBRATION:384,NFE_CALIBRATION:385,FE_TEMPCO:386,NFE_TEMPCO:387,NTC_PARA:388,REF_TEMP:389,FE_SCALING:390,NFE_SCALING:391,FACTORY_CAL_DATE:416,CERT_HEADER:417,CAL_STANDARDS:418,CERT_POINTS:419,PUBLIC_KEY:420,AMBIENT_CONDITIONS:421,SHA_HASH_VALUE:511,SFLASH_OTP:512,SFLASH_ID:513,MCU_UNIQUE_ID:514,MCU_TYPE_CODE:515,DEVICE_INFO:516},this.trigger_mode={AUTO:1,TRIG:2,SELECT:4,K:8,N:16,NONE:255},this.decoding={PROBE:0,GAUGE:1},this.decodingFlg=this.decoding.PROBE,this.intervalList=[]}}function ApplicationFile(){this.PackageSize=1020,this.FileState={OFF:0,FILEPATH:1,FILEDATA:2},this.RTS_Param={DATA:0,UPLOAD:1,DOWNLOAD:2,DIRECTORY:3,DELETE:15},this.ModeType={NONE:0,ACTIVE_DOWMLOAD:1,ACTIVE_UPLOAD:2,ACTIVE_DIR:3,ACTIVE_DEL:4,PASSIV_DOWNLOAD:11,PASSIV_UPLOAD:12,PASSIVE_DIR:13,PASSIVE_DEL:14},this.mode=this.ModeType.NONE,this.pathfile="",this.pathfileArr=[],this.size=0,this.fileProtocolPackageCounter=0,this.current_state=this.FileState.OFF,this.fp=null}ApplicationData.prototype.getCertHeader=function(dataRaw){let val,arr=dataRaw.data,certHeader={};if(dataRaw.size>=56){certHeader.certSerial=conv.convert4ByteTo32Bit(arr[0],arr[1],arr[2],arr[3]),val=conv.convert4ByteTo32Bit(arr[4],arr[5],arr[6],arr[7]),certHeader.certdate=conv.formatDateTimeStamp(conv.convertQnixTotime2Date(val,TimeOffset)),certHeader.tester=conv.convert4ByteTo32Bit(arr[8],arr[9],arr[10],arr[11]),certHeader.supervisor=conv.convert4ByteTo32Bit(arr[12],arr[13],arr[14],arr[15]),val=conv.convert4ByteTo32Bit(arr[16],arr[17],arr[18],arr[19]),certHeader.refdate=conv.formatDateTimeStamp(conv.convertQnixTotime2Date(val,TimeOffset)),certHeader.certdata=[],certHeader.certcount=[];for(let idx=0;idx<4;idx++)certHeader.certdata.push(arr[20+idx]),certHeader.certcount.push(arr[24+idx]);certHeader.fe_set_id=conv.convert4ByteTo32Bit(arr[28],arr[29],arr[30],arr[31]),certHeader.nfe_set_id=conv.convert4ByteTo32Bit(arr[32],arr[33],arr[34],arr[35]),certHeader.fe_set_sn=conv.convert4ByteTo32Bit(arr[36],arr[37],arr[38],arr[39]),certHeader.nfe_set_sn=conv.convert4ByteTo32Bit(arr[40],arr[41],arr[42],arr[43]),val=conv.convert4ByteTo32Bit(arr[44],arr[45],arr[46],arr[47]),certHeader.fe_set_datetime=conv.formatDateTimeStamp(conv.convertQnixTotime2Date(val,TimeOffset)),val=conv.convert4ByteTo32Bit(arr[48],arr[49],arr[50],arr[51]),certHeader.nfe_set_datetime=conv.formatDateTimeStamp(conv.convertQnixTotime2Date(val,TimeOffset)),certHeader.refdevice=arr[52],certHeader.template=arr[53],certHeader.certUnit=arr[54],certHeader.certLang=arr[55]}return certHeader},ApplicationData.prototype.getConditions=function(dataRaw){let arr=dataRaw.data,certConditions={};return dataRaw.size>=12&&(certConditions.temperature=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[0],arr[1],arr[2],arr[3])),certConditions.humidity=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[4],arr[5],arr[6],arr[7])),certConditions.airpressure=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[8],arr[9],arr[10],arr[11]))),isNaN(certConditions.temperature)&&(certConditions.temperature=0),isNaN(certConditions.humidity)&&(certConditions.humidity=0),isNaN(certConditions.airpressure)&&(certConditions.airpressure=0),certConditions},ApplicationData.prototype.getCalStandard=function(dataRaw){let serial=0,val=-1,tol=0,arr=dataRaw.data;return dataRaw.size>=12&&(serial=conv.convert4ByteTo32Bit(arr[0],arr[1],arr[2],arr[3]),val=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[4],arr[5],arr[6],arr[7])),tol=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[8],arr[9],arr[10],arr[11]))),[serial,val,tol]},ApplicationData.prototype.getCalPoint=function(dataRaw){let calPoint={val:-1,tol:0,standard1:0,standard2:0},secStd=!1,arr=dataRaw.data;return dataRaw.size<10?calPoint=null:dataRaw.size>=12&&(secStd=!0),calPoint.val=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[0],arr[1],arr[2],arr[3])),calPoint.tol=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[4],arr[5],arr[6],arr[7])),calPoint.standard1=conv.convert2ByteTo16Bit(arr[8],arr[9]),secStd&&(calPoint.standard2=conv.convert2ByteTo16Bit(arr[10],arr[11])),calPoint},ApplicationData.prototype.getCalDate=function(dataRaw){let d,arr=dataRaw.data;return dataRaw.size===arr.length&&(d=conv.formatDateTimeStamp(conv.convertQnixTotime2Date(conv.convert4ByteTo32Bit(arr[0],arr[1],arr[2],arr[3]),TimeOffset))),d},ApplicationData.prototype.getSN=function(dataRaw){let arr=dataRaw.data,sn=0;return dataRaw.size>=4&&(sn=conv.convert4ByteTo32Bit(arr[0],arr[1],arr[2],arr[3])),sn},ApplicationData.prototype.getNFe=function(dataRaw){let arr=dataRaw.data,val=[];if(dataRaw.size>=16)for(let i=0;i<4;i++)val.push(conv.convert4ByteTo32Bit(arr[0+4*i],arr[1+4*i],arr[2+4*i],arr[3+4*i]));return val},ApplicationData.prototype.getFe=function(dataRaw){let arr=dataRaw.data,val={};return dataRaw.size>=22&&(val.zero=conv.convert4ByteTo32Bit(arr[0],arr[1],arr[2],arr[3]),val.infi=conv.convert4ByteTo32Bit(arr[4],arr[5],arr[6],arr[7]),val.ur_0=conv.convert4ByteTo32Bit(arr[8],arr[9],arr[10],arr[11]),val.tk1=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[12],arr[13],arr[14],arr[15])),val.tk2=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[16],arr[17],arr[18],arr[19])),val.temp=conv.convert2ByteTo16Bit(arr[20],arr[21])/100),val},ApplicationData.prototype.getString=function(dataRaw){let s="";for(let idx=0;idx<dataRaw.size-1&&0!==dataRaw.data[idx];idx++)s+=String.fromCharCode(dataRaw.data[idx]);return s},ApplicationData.prototype.getVariant=function(dataRaw){let arr=dataRaw.data,sn=0;return dataRaw.size>=4&&(sn=conv.convert4ByteTo32Bit(arr[0],arr[1],arr[2],arr[3])),sn},ApplicationData.prototype.setIntervalList=function(list){let lowlimit,highlimit,mtype,alarm;this.intervalList=new Uint8Array(30);for(let listCounter=0;listCounter<3;listCounter++)lowlimit=conv.convertFloatToIEEE754Arr(list[listCounter].lowlimit),highlimit=conv.convertFloatToIEEE754Arr(list[listCounter].highlimit),mtype=list[listCounter].mtype,alarm=list[listCounter].alarm,this.intervalList[10*listCounter]=lowlimit[3],this.intervalList[10*listCounter+1]=lowlimit[2],this.intervalList[10*listCounter+2]=lowlimit[1],this.intervalList[10*listCounter+3]=lowlimit[0],this.intervalList[10*listCounter+4]=highlimit[3],this.intervalList[10*listCounter+5]=highlimit[2],this.intervalList[10*listCounter+6]=highlimit[1],this.intervalList[10*listCounter+7]=highlimit[0],this.intervalList[10*listCounter+8]=mtype,this.intervalList[10*listCounter+9]=alarm},ApplicationData.prototype.getMeasurement=function(arr){let measurement={mwtype:0,datetime:"",mw1:null,mw2:null,val:0,temp:null};if(arr.length<5)measurement=null;else{if(measurement.mwtype=arr[1],arr.length<3)return measurement;switch(measurement.mwtype){case this.mwtype.sd_fe:measurement.datetime=conv.formatDateTimeStamp(conv.convertQnixTotime2DateSub(conv.convert4ByteTo32Bit(arr[2],arr[3],arr[4],arr[5]),arr[6],TimeOffset)),measurement.mw1=conv.limitMeasurmentVal(conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[7],arr[8],arr[9],arr[10])));break;case this.mwtype.sd_nfe:measurement.datetime=conv.formatDateTimeStamp(conv.convertQnixTotime2DateSub(conv.convert4ByteTo32Bit(arr[2],arr[3],arr[4],arr[5]),arr[6],TimeOffset)),measurement.mw2=conv.limitMeasurmentVal(conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[7],arr[8],arr[9],arr[10])));break;case this.mwtype.duplex:measurement.datetime=conv.formatDateTimeStamp(conv.convertQnixTotime2DateSub(conv.convert4ByteTo32Bit(arr[2],arr[3],arr[4],arr[5]),arr[6],TimeOffset)),measurement.mw1=conv.limitMeasurmentVal(conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[7],arr[8],arr[9],arr[10]))),measurement.mw2=conv.limitMeasurmentVal(conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[11],arr[12],arr[13],arr[14])));break;case this.mwtype.ntc:measurement.temp=(conv.convert2ByteTo16Bit(arr[2],arr[3])/100).toFixed(2);break;case this.mwtype.uh_ic:measurement.val=conv.convert4ByteTo32Bit(arr[2],arr[3],arr[4],arr[5]),measurement.temp=(conv.convert2ByteTo16Bit(arr[6],arr[7])/100).toFixed(2);break;case this.mwtype.uh_ur:measurement.val=conv.convert4ByteTo32Bit(arr[2],arr[3],arr[4],arr[5]),measurement.mw2=conv.convert4ByteTo32Bit(arr[6],arr[7],arr[8],arr[9]),measurement.temp=(conv.convert2ByteTo16Bit(arr[10],arr[11])/100).toFixed(2);break;case this.mwtype.coil0:case this.mwtype.coil1:case this.mwtype.coil2:case this.mwtype.coil3:measurement.val=conv.convert4ByteTo32Bit(arr[2],arr[3],arr[4],arr[5]),measurement.temp=(conv.convert2ByteTo16Bit(arr[6],arr[7])/100).toFixed(2)}console.log("mwtype="+measurement.mwtype+"  mw1="+measurement.mw1+"  mw2="+measurement.mw2+"  val="+measurement.val+" temp="+measurement.temp)}return measurement},ApplicationData.prototype.getDeviceType=function(arr){let device_info={dtype:{tcode:0,h_version:0,s_major:0,s_minor:0,s_buildnr:0,variant:0},info:[]};return arr.length>=16?(device_info.dtype.tcode=conv.convert2ByteTo16Bit(arr[1],arr[2]),device_info.dtype.h_version=conv.convert2ByteTo16Bit(arr[3],arr[4]),device_info.dtype.s_major=conv.convert2ByteTo16Bit(arr[5],arr[6]),device_info.dtype.s_minor=conv.convert2ByteTo16Bit(arr[7],arr[8]),device_info.dtype.s_buildnr=conv.convert4ByteTo32Bit(arr[9],arr[10],arr[11],arr[12]),device_info.dtype.variant=conv.convert4ByteTo32Bit(arr[13],arr[14],arr[15],arr[16])):console.info("error - getDeviceType, not enough data!"),device_info},ApplicationData.prototype.getProbeInfo=function(arr){let val,probe_info={dtype:{tcode:0,h_version:0,s_major:0,s_minor:0,s_buildnr:0,variant:0},f_caldate:0,u_caldate:0,mcount:0,MAC_no:[]};return arr.length>28?(probe_info.dtype.tcode=conv.convert2ByteTo16Bit(arr[1],arr[2]),probe_info.dtype.h_version=conv.convert2ByteTo16Bit(arr[3],arr[4]),probe_info.dtype.s_major=conv.convert2ByteTo16Bit(arr[5],arr[6]),probe_info.dtype.s_minor=conv.convert2ByteTo16Bit(arr[7],arr[8]),probe_info.dtype.s_buildnr=conv.convert4ByteTo32Bit(arr[9],arr[10],arr[11],arr[12]),probe_info.dtype.variant=conv.convert4ByteTo32Bit(arr[13],arr[14],arr[15],arr[16]),val=conv.convert4ByteTo32Bit(arr[17],arr[18],arr[19],arr[20]),probe_info.f_caldate=conv.formatDateTimeStamp(conv.convertQnixTotime2Date(val,TimeOffset)),val=conv.convert4ByteTo32Bit(arr[21],arr[22],arr[23],arr[24]),probe_info.u_caldate=conv.formatDateTimeStamp(conv.convertQnixTotime2Date(val,TimeOffset)),probe_info.mcount=conv.convert4ByteTo32Bit(arr[26],arr[27],arr[28],arr[29]),arr.length>34&&probe_info.MAC_no.push(arr[29])):console.info("error - getProbeInfo, not enough data!"),probe_info},ApplicationData.prototype.getIdentify=function(arr){let identifier={},idArr=[];return arr.length>16?(identifier.serial=conv.convert4ByteTo32Bit(arr[1],arr[2],arr[3],arr[4]),idArr.push(conv.convert4ByteTo32Bit(arr[5],arr[6],arr[7],arr[8])),idArr.push(conv.convert4ByteTo32Bit(arr[9],arr[10],arr[11],arr[12])),idArr.push(conv.convert4ByteTo32Bit(arr[13],arr[14],arr[15],arr[16])),identifier.id=conv.convert2Hex32(idArr[0])+" "+conv.convert2Hex32(idArr[1])+" "+conv.convert2Hex32(idArr[2]),identifier.raw=[arr[5],arr[6],arr[7],arr[8],arr[9],arr[10],arr[11],arr[12],arr[13],arr[14],arr[15],arr[16]]):identifier=null,identifier},ApplicationData.prototype.getMeasureModes=function(arr){let measuremode,list=[];for(let i=0;i<arr.length;i+=7)measuremode=new Measuremode,arr.length>i+6&&(measuremode.mtype=arr[i],measuremode.time=conv.convert16BitToFloat(arr[i+1],arr[i+2]),measuremode.rangehigh=conv.convert16BitToFloat(arr[i+3],arr[i+4]),measuremode.rangelow=conv.convert16BitToFloat(arr[i+5],arr[i+6]),list.push(measuremode));return list},ApplicationData.prototype.getAdjList=function(arr){let pointList=[];if(arr>9){let count=Math.trunc((arr-1)/9);for(let no=0;no<count;no++){let calibration_point={};calibration_point.type=arr[9*no+1],calibration_point.fact_val=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[9*no+2],arr[9*no+3],arr[9*no+4],arr[9*no+5])),calibration_point.cal_val=conv.convertIEEE754_32BitToFloat(conv.convert4ByteTo32Bit(arr[9*no+2],arr[9*no+3],arr[9*no+4],arr[9*no+5])),pointList.push(calibration_point)}}else pointList=null;return pointList},ApplicationData.prototype.setAdjPoint=function(type,fact_val,cal_val){let i,arr=[],factArr=conv.convertFloatToIEEE754Arr(fact_val),calArr=conv.convertFloatToIEEE754Arr(cal_val);for(arr.push(type),i=0;i<4;i++)arr.push(factArr[i]);for(i=0;i<4;i++)arr.push(calArr[i]);return arr},ApplicationData.prototype.processingGetVariable=function(vartype,v){let data={};switch(vartype){case applicationLayer.data.vartype.SERIAL_NUMBER:data=applicationLayer.data.getSN(v);break;case applicationLayer.data.vartype.CERT_HEADER:data=applicationLayer.data.getCertHeader(v);break;case applicationLayer.data.vartype.AMBIENT_CONDITIONS:data=applicationLayer.data.getConditions(v);break;case applicationLayer.data.vartype.CAL_STANDARDS:data=applicationLayer.data.getCalStandard(v);break;case applicationLayer.data.vartype.CERT_POINTS:data=applicationLayer.data.getCalPoint(v);break;case applicationLayer.data.vartype.FACTORY_CAL_DATE:data=applicationLayer.data.getCalDate(v);break;case applicationLayer.data.vartype.NFE_ZERO_COUNT:case applicationLayer.data.vartype.NFE_INFI_COUNT:data=applicationLayer.data.getNFe(v);break;case applicationLayer.data.vartype.FE_BASE_ADJUST:data=applicationLayer.data.getFe(v);break;case applicationLayer.data.vartype.PRODUCT_KEY:case applicationLayer.data.vartype.DEVICE_NAME:data=applicationLayer.data.getString(v);break;case applicationLayer.data.vartype.DEVICE_VARIANT:data=applicationLayer.data.getVariant(v);break;default:data=v}return data},ApplicationData.prototype.getVariable=function(currentVariable,data){let v={};if(data.length>2){if(v.size=conv.convert2ByteTo16Bit(data[1],data[2]),v.data=[],0!==v.size)if(data.length>=v.size+3)for(let idx=0;idx<v.size;idx++)v.data.push(data[3+idx]);else console.info("error - GET_VARIABLE wrong count of data. Size="+v.size),v.size=0;return this.processingGetVariable(currentVariable,v)}return null},ApplicationFile.prototype.prepareUpload=function(){let error=!1;try{let stats=fs.statSync(this.pathfile);this.size=stats.size,this.fileProtocolPackageCounter=Math.trunc(this.size/this.PackageSize),this.fp=fs.openSync(this.pathfile,"r"),this.current_state=this.FileState.FILEDATA}catch(err){console.info("error - prepare file upload"),error=!0}return error},ApplicationFile.prototype.readPackage=function(){let s,buffSize=0===this.fileProtocolPackageCounter?this.size%this.PackageSize:this.PackageSize,buffer=new Buffer(buffSize);return this.fileProtocolPackageCounter>0?(s=(Math.trunc(this.size/this.PackageSize)-this.fileProtocolPackageCounter)*this.PackageSize,this.fileProtocolPackageCounter--,fs.readSync(this.fp,buffer,0,buffSize,s)):(s=Math.trunc(this.size/this.PackageSize)*this.PackageSize,fs.readSync(this.fp,buffer,0,buffSize,s),fs.closeSync(this.fp),this.FileState=this.FileState.OFF,this.current_state=this.mode.ModeType.NONE),buffer},ApplicationFile.prototype.prepareDownload=function(){this.fp=fs.openSync(this.pathfile,"a"),this.size=0},ApplicationFile.prototype.writePackage=function(arr){this.fileProtocolPackageCounter=conv.convert4ByteTo32Bit(arr[1],arr[2],arr[3],arr[4]);let data=new Buffer(arr);fs.writeSync(this.fp,data,5,data.length-5),0===this.fileProtocolPackageCounter&&(fs.closeSync(this.fp),this.FileState=this.FileState.OFF,this.current_state=this.mode.ModeType.NONE)},ApplicationFile.prototype.preparePackageToString=function(){this.pathfile="",this.pathfileArr=[]},ApplicationFile.prototype.buildPathFile=function(arr){this.fileProtocolPackageCounter=conv.convert4ByteTo32Bit(arr[1],arr[2],arr[3],arr[4]),this.pathfileArr.push(arr.slice(5,arr.length)),0===this.fileProtocolPackageCounter&&(this.pathfile=UTF8.getStringFromBytes(this.pathfileArr))},ApplicationFile.prototype.prepareStringToPackage=function(){this.pathfileArr=UTF8.setBytesFromString(this.pathfile),this.size=this.pathfileArr.length,this.fileProtocolPackageCounter=Math.trunc(this.size/this.PackageSize),this.current_state=this.FileState.FILEPATH},ApplicationFile.prototype.buildPackage=function(){let s,e;return this.fileProtocolPackageCounter>0?(s=(Math.trunc(this.size/this.PackageSize)-this.fileProtocolPackageCounter)*this.PackageSize,e=(Math.trunc(this.size/this.PackageSize)-this.fileProtocolPackageCounter+1)*this.PackageSize,this.fileProtocolPackageCounter--):(s=Math.trunc(this.size/this.PackageSize)*this.PackageSize,e=this.size),this.pathfileArr.slice(s,e)};class ApplicationLayer{constructor(){this.RequestBit=128,this.command={NONE:0,HOST_EVENT:16,X_ON:17,X_OFF:19,SET_VARIABLE:53,CLR_ADJUSTMENT:54,MEASUREMENT:55,SET_LIMIT:56,CMD_ERROR:57,EMIT_SIGNAL:58,SET_MEASUREMODE:59,SET_DATETIME:60,SET_INTERVAL:61,SET_ADJPOINT:62,UPD_ADJPOINT:63,START_ADJUSTMENT:64,GET_PROBEINFO:65,CLR_LIMITS:66,SYSTEM:111,GET_VARSIZE:112,GET_VARIABLE:113,COM_FORWARD:114,RTS_MEASUREMENT:115,GET_FILE:116,RTS_FILE:117,GET_LIMIT:118,GET_DEVICETYPE:119,GET_DATETIME:120,SET_DATARATE:121,GET_MEASUREMODES:122,IDENTIFY:123,GET_ADJUSTMENT:124,SET_SN:125},this.currentCommand=0,this.currentVar=0,this.errorType={ERR_UNKNOWN:1,ERR_INDEX:2,ERR_INIT:3,ERR_PARAM:4,ERR_MATH:5,ERR_FILE_UNKNOWN:16,ERR_FILE_BROKEN:17,ERR_GET_FILE:18,ERR_UNDEFINED:255},this.signalType={NONE:0,DEFAULT:1,WARNING:2,CRITICAL:3,ERROR:4,LOW:5,HIGH:6},this.error=this.errorType.none,this.receivingSequenz=[],this.receivedCMD=0,this.dataLayer_SendFrame=null,this.dataLayer_setBaudRate=null,this.dataLayer_setResponseObject=null,this.data=new ApplicationData,this.file=new ApplicationFile,this.resultFunc=null}}applicationLayer=new ApplicationLayer,ApplicationLayer.prototype.getError=function(arr){let errorCode=0;return errorCode=2===arr.length?arr[1]:null,errorCode},ApplicationLayer.prototype.sendRequest=function(command,resultFunc,paramArr,syncFlg){this.resultFunc=resultFunc,this.currentCommand=command;let req=[command|this.RequestBit];if(console.log("sendRequest "+req[0].toString(16)),void 0!==paramArr&&paramArr.length>0){let paramIdx;for(paramIdx=0;paramIdx<paramArr.length;paramIdx++)req.push(paramArr[paramIdx])}void 0!==syncFlg?this.dataLayer_SendFrame(req,syncFlg):this.dataLayer_SendFrame(req)},ApplicationLayer.prototype.processRTS_FILE_response=function(){switch(this.file.mode){case this.file.ModeType.ACTIVE_DOWMLOAD:case this.file.ModeType.ACTIVE_DEL:case this.file.ModeType.ACTIVE_DIR:this.file.current_state===this.file.FileState.OFF?this.file.prepareStringToPackage():console.error("error - received invalid active RTS_FILE-Response");break;case this.file.ModeType.ACTIVE_UPLOAD:this.file.current_state===this.file.FileState.OFF?this.file.prepareStringToPackage():this.file.current_state===this.file.FileState.FILEPATH?this.file.prepareUpload():console.error("error - invalid active upload RTS_FILE-Response");break;default:console.error("error - passive file mode not implemented")}},ApplicationLayer.prototype.processGET_FILE_response=function(data){if(this.file.mode===this.file.ModeType.ACTIVE_DOWMLOAD)this.file.current_state,this.file.FileState.FILEPATH;else console.error("error - GET_FILE")},ApplicationLayer.prototype.processRTS_FILE_request=function(data){if(data.length>1)switch(data[1]){case this.file.RTS_Param.DATA:switch(this.file.mode){case this.file.ModeType.ACTIVE_DOWMLOAD:case this.file.ModeType.ACTIVE_DIR:break;default:this.sendResponseError(this.errorType.ERR_UNKNOWN),console.error("error - invalid RTS_FILE request")}break;case this.file.RTS_Param.DOWNLOAD:case this.file.RTS_Param.UPLOAD:break;case this.file.RTS_Param.DELETE:case this.file.RTS_Param.DIRECTORY:this.sendResponseError(this.errorType.ERR_UNKNOWN),console.error("error - this RTS_FILE request is not implemented");break;default:this.sendResponseError(this.errorType.ERR_PARAM),console.error("error - unknown RTS_FILE request type")}else this.sendResponseError(this.errorType.ERR_PARAM)},ApplicationLayer.prototype.processGET_FILE_request=function(){if(this.file.current_state===this.file.FileState.FILEDATA);else if(this.file.current_state===this.file.FileState.FILEPATH){conv.convert32BitToArr(this.file.fileProtocolPackageCounter).push(this.file.buildPackage())}else console.info("error - GET_FILE request without RTS_FILE"),this.sendResponseError(this.errorType.ERR_GET_FILE)},ApplicationLayer.prototype.receivingData=function(data){if(console.log("ApplicationLayer.receivingData..."),this.receivingSequenz=data,this.receivedCMD=127&this.receivingSequenz[0],this.receivingSequenz[0]<this.RequestBit){if(this.receivedCMD!==this.currentCommand){switch(this.receivedCMD){case this.command.MEASUREMENT:console.log("receiving measurement data...");let measurement=this.data.getMeasurement(data);null===measurement?this.sendResponseError(this.errorType.ERR_PARAM):Sockets.emit("MVAL",JSON.stringify(measurement));break;case this.command.CMD_ERROR:console.log("receiving CMD_ERROR ...");let errCode=this.getError(data);console.log("receiving CMD_ERROR "+errCode),null===errCode||this.sendResponseWithoutData();break;case this.command.GET_VARSIZE:console.error("receiving GET_VARSIZE");break;case this.command.GET_VARIABLE:console.error("receiving GET_VARIABLE");break;case this.command.COM_FORWARD:console.error("receiving COM_FORWARD");break;case this.X_ON:console.info("receiving X-ON"),this.sendResponseWithoutData();break;case this.X_OFF:console.info("receiving X-OFF"),this.sendResponseWithoutData();break;case this.HOST_EVENT:console.info("receiving HOST-EVENT"),this.sendResponseWithoutData();break;default:console.error("error receiving request Data  - unexpected response cmd="+this.receivedCMD.toString(16))}return}switch(this.receivedCMD){case this.command.X_ON:console.log("response X_ON received");break;case this.command.X_OFF:console.log("response X_OFF received");break;case this.command.CLR_ADJUSTMENT:console.log("response CLR_ADJUSTMENT received");break;case this.command.START_ADJUSTMENT:console.log("response START_ADJUSTMENT received");break;case this.command.SET_LIMIT:console.log("response SET_LIMITS received");break;case this.command.CMD_ERROR:if(data.length>1){let err=this.getErrorType(data[1]);switch(console.info("error response for cmd="+this.currentCommand+" error="+err),err){case"ERR_UNKNOWN":case"ERR_INDEX":case"ERR_INIT":case"ERR_PARAM":case"ERR_MATH":case"ERR_FILE_UNKNOWN":case"ERR_FILE_BROKEN":break;default:console.error("error response unknown errorcode")}}else console.error("response ERROR received without errorcode");break;case this.command.EMIT_SIGNAL:console.log("response EMIT_SIGNAL received");break;case this.command.SET_MEASUREMODE:console.log("response SET_MEASUREMODE received");break;case this.command.SET_DATETIME:console.log("response SET_DATETIME received - ignored, not supported");break;case this.command.SET_INTERVAL:console.log("response SET_MEASUREMODE received");break;case this.command.SET_ADJPOINT:console.log("response SET_ADJPOINT received");break;case this.command.UPD_ADJPOINT:console.log("response UPD_ADJPOINT received");break;case this.command.GET_PROBEINFO:console.log("response GET_PROBEINFO received");let probe_info=this.data.getProbeInfo(data);null!==probe_info?console.log("response GET_PROBEINFO ok "):console.error("error response GET_PROBEINFO - too few data"),this.resultFunc(probe_info);break;case this.command.RTS_MEASUREMENT:console.log("response UPD_RTS_MEASUREMENT received, MEASUREMENT is expected");break;case this.command.GET_FILE:this.processGET_FILE_response(data);break;case this.command.RTS_FILE:this.processRTS_FILE_response();break;case this.command.GET_DEVICETYPE:console.log("response GET_DEVICETYPE received");let device_type=this.data.getDeviceType(data);null!==device_type?console.log("response GET_DEVICETYPE ok "):console.error("error response GET_DEVICETYPE - too few data"),this.resultFunc(device_type);break;case this.command.GET_DATETIME:let datetime;if(data.length>4){let d=conv.convert4ByteTo32Bit(data[1],data[2],data[3],data[4]);datetime=conv.formatDateTimeStamp(conv.convertQnixTotime2Date(d,TimeOffset)),console.log("response GET_DATETIME received. Send datetime: "+datetime)}else console.error("error response SET_DATETIME - too few data");this.resultFunc(datetime);break;case this.command.SET_DATARATE:console.log("response SET_DATARATE received ("+this.baudRate+"baud)"),this.dataLayer_setBaudRate(this.baudRate),console.info("new baud rate was set");break;case this.command.GET_MEASUREMODES:console.log("response GET_MESUREMODES received");let list=this.data.getMeasureModes(data);null!==list?this.resultFunc(list):console.error("error response GET_MEASUREMODES - too few data");break;case this.command.IDENTIFY:console.log("response IDENTIFY received");let device=this.data.getIdentify(data);null===device&&console.error("error response IDENTIFY - too few data"),this.resultFunc(device);break;case this.command.GET_ADJUSTMENT:console.log("response UPD_ADJUSTMENT received");let points=this.data.getAdjList(data);null!==points?console.log("response GET_ADJUSTMENT received, number = "+points.length):console.error("error response GET_ADJUSTMENT - too few data"),this.resultFunc(points);break;case this.command.SET_SN:console.error("response SET_SN received");break;case this.command.GET_VARSIZE:console.log("response GET_VARSIZE received"),5===data.length?this.resultFunc(conv.convert4ByteTo32Bit(data[1],data[2],data[3],data[4])):console.error("error response GET_VARSIZE - wrong count of data");break;case this.command.GET_VARIABLE:let v=this.data.getVariable(this.currentVar,data);null!==v?console.log("response GET_VARIABLE received"):console.error("error response GET_VARIABLE - wrong count of data"),this.resultFunc(v);break;case this.command.SET_VARIABLE:console.log("response SET_VARIABLE received");break;case this.command.COM_FORWARD:console.error("response COM_FORWARD received");break;default:console.info("error receivingData - unknown response "+this.receivedCMD.toString(16))}this.currentCommand=this.command}else switch(this.receivedCMD){case this.command.HOST_EVENT:console.log("--\x3e HOST_EVENT"),this.sendResponseWithoutData();break;case this.command.X_ON:console.log("--\x3e X_ON"),this.sendResponseWithoutData();break;case this.command.X_OFF:console.log("--\x3e X_OFF"),this.sendResponseWithoutData();break;case this.command.MEASUREMENT:console.log("receiving measurement data... (?)");break;case this.command.CMD_ERROR:console.log("--\x3e CMD_ERROR"),null===this.getError(data)?this.sendResponseError(this.errorType.ERR_PARAM):(this.sendResponseWithoutData(),console.info("error request received "+this.getErrorType(data[1])));break;case this.command.GET_FILE:console.log("--\x3e RTS_FILE"),this.processGET_FILE_request();break;case this.command.RTS_FILE:console.log("--\x3e RTS_FILE"),this.processRTS_FILE_request(data);break;case this.command.GET_LIMIT:console.log("--\x3e GET_LIMIT"),this.sendResponse(this.data.intervalList);break;case this.command.GET_DATETIME:console.log("--\x3e GET_DATETIME");let dQnix=conv.convertDateToQnix_time(new Date),arr=conv.convert32BitToArr(dQnix);this.sendResponse(arr);break;case this.command.SET_DATETIME:console.log("--\x3e GET_DATETIME"),this.sendResponseWithoutData();break;case this.command.SET_DATARATE:if(data.length>4){this.sendResponseWithoutData();let d=conv.convert4ByteTo32Bit(data[1],data[2],data[3],data[4]);console.log("request SET_DATARATE received. Set baud rate to "+d),this.baudRate=d,this.dataLayer_setBaudRate(d)}else this.sendResponseError(this.errorType.ERR_PARAM);break;case this.command.SET_VARIABLE:console.info("--\x3e SET_VARIABLE"),this.sendResponseError(this.errorType.ERR_UNKNOWN);break;case this.command.GET_VARIABLE:console.info("--\x3e GET_VARIABLE"),this.sendResponseError(this.errorType.ERR_UNKNOWN);break;case this.command.IDENTIFY:console.info("--\x3e IDENTIFY"),null===this.data.getIdentify(data)&&(console.error("error response IDENTIFY"),this.sendResponseError(this.errorType.ERR_PARAM));break;default:console.info("error receivingData - not implemented command "+this.receivedCMD.toString(16))}},ApplicationLayer.prototype.sendResponseWithoutData=function(){this.dataLayer_SendFrame([this.receivedCMD])},ApplicationLayer.prototype.sendResponseError=function(errorCode){this.dataLayer_SendFrame([this.command.CMD_ERROR,errorCode])},ApplicationLayer.prototype.sendResponse=function(data){let dataFrame=data;dataFrame.unshift(this.receivedCMD),this.dataLayer_SendFrame(dataFrame)},ApplicationLayer.prototype.getErrorType=function(errorCode){let err;switch(errorCode){case 1:err="ERR_UNKNOWN";break;case 2:err="ERR_INDEX";break;case 3:err="ERR_INIT";break;case 4:err="ERR_PARAM";break;case 5:err="ERR_MATH";break;case 16:err="ERR_FILE_UNKNOWN";break;case 17:err="ERR_FILE_BROKEN";break;default:err="ERR"}return err};let set_variable=function(res,varnum,index,size,dataArr,resultFunc){console.log("applicationLayer set_variable("+varnum+")");let arr=[],val=conv.convert16BitToArr(varnum);if(arr.push(val[0],val[1]),val=conv.convert16BitToArr(index),arr.push(val[0],val[1]),val=conv.convert16BitToArr(size),arr.push(val[0],val[1]),size===dataArr.length){for(let i=0;i<dataArr.length;i++)arr.push(dataArr[i]);applicationLayer.dataLayer_setResponseObject(res),applicationLayer.currentVar=0,applicationLayer.sendRequest(applicationLayer.command.SET_VARIABLE,resultFunc,arr,!0)}else resultFunc(new Error("error - SET_VARIABLE, wrong lenght"))},get_variable=function(res,varnum,index,e_size,resultFunc){console.log("applicationLayer get_variable()");let arr=[];applicationLayer.dataLayer_setResponseObject(res);let val=conv.convert16BitToArr(varnum);arr.push(val[0],val[1]),val=conv.convert16BitToArr(index),arr.push(val[0],val[1]),val=conv.convert16BitToArr(e_size),arr.push(val[0],val[1]),applicationLayer.currentVar=varnum,applicationLayer.sendRequest(applicationLayer.command.GET_VARIABLE,resultFunc,arr)},get_varsize=function(res,varnum,resultFunc){console.log("applicationLayer get_varsize()");let arr=conv.convert16BitToArr(varnum);applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.GET_VARSIZE,resultFunc,arr)};module.exports={vartype:applicationLayer.data.vartype,mwtype:applicationLayer.data.mwtype,trigger_mode:applicationLayer.data.trigger_mode,signalType:applicationLayer.signalType,decoding:applicationLayer.data.decoding,next_message(){console.info("next_message, ready for next message")},referModule(sendFrameMethod,setBaudRateMethod,setResponseObject,io){applicationLayer.dataLayer_SendFrame=sendFrameMethod,applicationLayer.dataLayer_setBaudRate=setBaudRateMethod,applicationLayer.dataLayer_setResponseObject=setResponseObject,Sockets=io},getDataHandler:()=>applicationLayer.receivingData.bind(applicationLayer),clr_adjustment(res,mwtype,resultFunc){console.log("applicationLayer clr_adjustment()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.CLR_ADJUSTMENT,resultFunc,[mwtype],!0)},get_adjustment(res,resultFunc){console.log("applicationLayer get_adjustment()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.GET_ADJUSTMENT,resultFunc)},set_limit(res,intervalList,resultFunc){console.log("applicationLayer set_limit()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.data.setIntervalList(intervalList),applicationLayer.sendRequest(applicationLayer.command.RTS_LIMITS,resultFunc,applicationLayer.data.intervalList)},send_error(res,error,resultFunc){let errorCode;switch(console.info("applicationLayer send_error()"),applicationLayer.dataLayer_setResponseObject(res),error){case"ERR_UNKNOWN":errorCode=applicationLayer.errorType.ERR_UNKNOWN;break;case"ERR_INDEX":errorCode=applicationLayer.errorType.ERR_INDEX;break;case"ERR_INIT":errorCode=applicationLayer.errorType.ERR_INIT;break;case"ERR_PARAM":errorCode=applicationLayer.errorType.ERR_PARAM;break;case"ERR_MATH":errorCode=applicationLayer.errorType.ERR_MATH;break;case"ERR_FILE_UNKNOWN":errorCode=applicationLayer.errorType.ERR_FILE_UNKNOWN;break;case"ERR_FILE_BROKEN":errorCode=applicationLayer.errorType.ERR_FILE_BROKEN;break;case"ERR_GET_FILE":errorCode=applicationLayer.errorType.ERR_GET_FILE;break;case"ERR_UNDEFINED":errorCode=applicationLayer.errorType.ERR_UNDEFINED;break;default:return errorCode=applicationLayer.errorType.ERR_UNDEFINED,void console.error("error send_error - unknown error")}applicationLayer.sendRequest(applicationLayer.command.CMD_ERROR,resultFunc,[errorCode])},emit_signal(res,signal,resultFunc){console.log("applicationLayer emit_signal("+signal+")"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.EMIT_SIGNAL,resultFunc,[signal])},set_measuremode(res,index,trigger_mode,resultFunc){let arr=[];console.log("applicationLayer set_measuremode()"),arr.push(255&index),""!==trigger_mode?arr.push(255&trigger_mode):arr.push(255),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.SET_MEASUREMODE,resultFunc,arr,!0)},set_datetime(res,dt,resultFunc){console.log("applicationLayer set_datetime()"),applicationLayer.dataLayer_setResponseObject(res);let qnixDateTime=conv.convertDateToQnix_time(dt),arr=conv.convert32BitToArr(qnixDateTime);applicationLayer.sendRequest(applicationLayer.command.SET_DATETIME,resultFunc,arr)},set_interval(res,time_interval,resultFunc){console.error("applicationLayer set_interval()");let val=conv.convertFloatTo16Bit(time_interval);applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.SET_INTERVAL,resultFunc,val)},set_adjpoint(res,type,fact_val,cal_val,resultFunc){console.log("applicationLayer set_adjpoint()"),applicationLayer.dataLayer_setResponseObject(res);let arr=applicationLayer.data.setAdjPoint(type,fact_val,cal_val);applicationLayer.sendRequest(applicationLayer.command.SET_ADJPOINT,resultFunc,arr)},upd_adjpoint(res,type,fact_val,cal_val,resultFunc){console.log("applicationLayer upd_adjpoint()"),applicationLayer.dataLayer_setResponseObject(res);let arr=applicationLayer.data.setAdjPoint(type,fact_val,cal_val);applicationLayer.sendRequest(applicationLayer.command.UPD_ADJPOINT,resultFunc,arr)},rts_measurement(res,trigger_mode,mtype,resultFunc){console.log("applicationLayer rts_measurement()");let arr=[];applicationLayer.dataLayer_setResponseObject(res),arr.push(255&trigger_mode),arr.push(255&mtype),applicationLayer.sendRequest(applicationLayer.command.RTS_MEASUREMENT,resultFunc,arr,!0)},get_devicetype(res,resultFunc){console.log("applicationLayer get_devicetype()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.GET_DEVICETYPE,resultFunc)},get_probeinfo(res,resultFunc){console.log("applicationLayer get_probeinfo()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.GET_PROBEINFO,resultFunc)},get_datetime(res,resultFunc){console.log("applicationLayer get_datetime()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.GET_DATETIME,resultFunc)},set_datarate(res,baudRate,resultFunc){console.log("applicationLayer set_datarate()");let arr=conv.convert32BitToArr(baudRate);applicationLayer.baudRate=baudRate,applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.SET_DATARATE,resultFunc,arr)},get_measuremodes(res,resultFunc){console.log("applicationLayer get_measuremodes()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.GET_MEASUREMODES,resultFunc)},get_identify(res,resultFunc){console.log("applicationLayer get_identify()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.IDENTIFY,resultFunc)},set_SN(res,sn,resultFunc){console.log("applicationLayer set_SN()");let snVal=parseInt(sn),arr=conv.convert32BitToArr(snVal);applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.SET_SN,resultFunc,arr)},set_variable:set_variable,get_variable:get_variable,get_varsize:get_varsize,com_forward(res,flg,resultFunc){let val;val="string"==typeof flg?"true"===flg?1:0:flg?1:0,applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.COM_FORWARD,resultFunc,[val],!0)},get_limit(res,index,resultFunc){console.log("applicationLayer get_limit()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.GET_LIMIT,resultFunc,[index])},start_adjustment(res,index,mode,resultFunc){console.log("applicationLayer start_adjustment()"),applicationLayer.dataLayer_setResponseObject(res),applicationLayer.sendRequest(applicationLayer.command.START_ADJUSTMENT,resultFunc,[index,mode])},system(res,func_no,resultFunc){console.log("applicationLayer system()"),applicationLayer.dataLayer_setResponseObject(res);let arr=conv.convert16BitToArr(func_no);applicationLayer.sendRequest(applicationLayer.command.SYSTEM,resultFunc,arr)},setMeasurementInterpreting(flg){console.log("applicationLayer set_Measurement_interpreting -> "+flg===applicationLayer.data.decoding.GAUGE?"gauge":"probe"),applicationLayer.data.decodingFlg=flg},setTimeOffset(offset){TimeOffset=offset,console.log("applicationLayer setTimeOffset")}};