"use strict";const Path=require("path"),fs=require("fs-extra"),conv=require("./convert.js");console.info("Modul certificate loading...");const pathTemp=Path.join(Path.dirname(__dirname),"public"),tempCertificateFilename="tempReport.html",currentHTMLCertificateFilename="certificate",certFileName="certificate.pdf",pathQNDBfile=Path.join(__dirname,"../","data","QNdata.json"),Enum_Unit={none:0,um:1,mm:2,mil:3},um2mil=25.4;let saveAs2HTMLpages=function(path,content){let pos=content.indexOf("<body>")+6,header=content.substring(0,pos);pos=content.indexOf("\x3c!-- Seite 2 --\x3e");let page2=header+content.substring(pos+18,content.length),page1=content.substring(0,pos)+"</body></html>",p=Path.join(path,currentHTMLCertificateFilename+"1.html");fs.writeFileSync(p,page1,"utf8"),p=Path.join(path,currentHTMLCertificateFilename+"2.html"),fs.writeFileSync(p,page2,"utf8")},loadCertificateTemplate=function(path,lang){let filename=Path.basename(path),templatePath=Path.join(Path.dirname(__dirname),"data","certificates",lang,filename),content="";try{content=fs.readFileSync(templatePath,"utf8")}catch(err){console.error("file error - can't load the certificate template file!")}return content},loadCertificateTemplateEvelope=function(file){let content,templatePath=Path.join(Path.dirname(__dirname),"data","certificates",file);try{content=fs.readFileSync(templatePath,"utf8")}catch(err){console.error("file error - can't load the certificate template header/footer"),content=""}return content},saveCertificateFile=function(content){let error=!1;try{let pathFile=Path.join(pathTemp,tempCertificateFilename);fs.writeFileSync(pathFile,content,"utf8"),saveAs2HTMLpages(pathTemp,content)}catch(err){error=!0,console.error("file error - can't save the html certificate file!")}return error},testConformity=function(row){let okFlg=!0;return(row.val_um<row.min_um||row.val_um>row.max_um)&&(okFlg=!1),okFlg},formatAccuracyUmStr=function(percent,offset){let str,offsetStr,percentStr;return 0===percent?(offsetStr=offset-Math.floor(offset)!=0?offset.toFixed(1):offset.toFixed(0),str="&plusmn;"+offsetStr+"µm"):0===offset?(percentStr=percent-Math.floor(percent)!=0?percent.toFixed(1):percent.toFixed(0),str="&plusmn;"+percentStr+"%"):(offsetStr=offset-Math.floor(offset)!=0?offset.toFixed(1):offset.toFixed(0),percentStr=percent-Math.floor(percent)!=0?percent.toFixed(1):percent.toFixed(0),str="&plusmn;("+percentStr+"% +"+offsetStr+"µm)"),str},formatAccuracyMilStr=function(percent,offset){let str,offsetStr,percentStr;return offset/=um2mil,0===percent?(offsetStr=Math.round(1e3*offset)/1e3,str="&plusmn;"+offsetStr+"mil"):0===offset?(percentStr=percent-Math.floor(percent)!=0?percent.toFixed(3):percent.toFixed(0),str="&plusmn;"+percentStr+"%"):(offsetStr=Math.round(1e3*offset)/1e3,percentStr=percent-Math.floor(percent)!=0?percent.toFixed(3):percent.toFixed(0),str="&plusmn;("+percentStr+"% +"+offsetStr+"mil)"),str},formatAccuracyStrings=function(accuracy){let strUm,strMil,strUm1,strMil1;switch(accuracy.length){case 0:strUm="-",strMil="-";break;case 1:strUm=formatAccuracyUmStr(accuracy[0].percent,accuracy[0].offset),strMil=formatAccuracyMilStr(accuracy[0].percent,accuracy[0].offset);break;case 2:if(strUm1=accuracy[0].end>1e3?(accuracy[0].end/1e3).toFixed(0)+"mm":accuracy[0].end+"µm",strMil1=(accuracy[0].end/um2mil).toFixed(1)+"mil",strUm1="&#8804;"+strUm1+": "+formatAccuracyUmStr(accuracy[0].percent,accuracy[0].offset)+"; ",strMil1="&#8804;"+strMil1+": "+formatAccuracyMilStr(accuracy[0].percent,accuracy[0].offset)+"; ",accuracy.length>1){strUm=accuracy[1].start>1e3?(accuracy[1].start/1e3).toFixed(0)+"mm":accuracy[1].start+"µm",strMil=(100*Math.round(accuracy[1].start/100)/um2mil).toFixed(1)+"mil",strUm=">"+strUm+": "+formatAccuracyUmStr(accuracy[1].percent,accuracy[1].offset),strMil=">"+strMil+": "+formatAccuracyMilStr(accuracy[1].percent,accuracy[1].offset)}else strUm="",strMil="";strUm=strUm1+strUm,strMil=strMil1+strMil;break;case 3:break;default:console.error("error - format accuracy, too many accuracy information"),strUm="...",strMil="..."}return{um:strUm,mil:strMil}},replaceCertificateData=function(template,data1,data2,probeData){let d;for(let i=0;i<2;i++)template=(template=template.replace("$probeNameLANG1",data2.probeLANG1)).replace("$probeNameLANG2",data2.probeLANG2);template=(template=template.replace("$probeKey",data2.key)).replace("$probeSerial",probeData.serialnumber);let accuracy=formatAccuracyStrings(data2.accuracyFe);template=(template=template.replace("$probeAccFeLANG1",accuracy.um)).replace("$probeAccFeLANG2",accuracy.mil),accuracy=formatAccuracyStrings(data2.accuracyNFe),template=(template=(template=template.replace("$probeAccNFeLANG1",accuracy.um)).replace("$probeAccNFeLANG2",accuracy.mil)).replace("$standardKey",data2.foilset_productkey),d=0===data1.fe_set_datetime.length?new Date(data1.nfe_set_datetime):new Date(data1.fe_set_datetime),template=template.replace("$standardDate",conv.formatDate(d)),template=(template=(template=(template=0===data1.fe_set_sn.length?template.replace("$standardSerial",data1.nfe_set_sn):template.replace("$standardSerial",data1.fe_set_sn)).replace("$referenceName",data2.refStandard)).replace("$referenceSerial",data2.refSerial)).replace("$referenceMark",data2.refMark),d=new Date(data1.refdate),template=template.replace("$referenceDate",conv.formatDate(d));for(let i=0;i<2;i++)template=template.replace("$certSerial",data1.certSerial);return d=new Date(data1.certdate),template=(template=(template=(template=(template=template.replace("$sigdate",conv.formatDate(d))).replace("$supervisor",data2.supervisor.name)).replace("$technician",data2.tester.name)).replace("$signature1",data2.supervisor.signature)).replace("$signature2",data2.tester.signature)},replaceConditionData=function(template,data){var celsius;return template=(template=(template=(template=template.replace("$temperatureLANG1",data.temperature.toFixed(1)+"°C &plusmn;2°C")).replace("$temperatureLANG2",(celsius=data.temperature,1.8*parseFloat(celsius)+32).toFixed(1)+"°F &plusmn;35.6°F")).replace("$humidity",data.humidity.toFixed(1)+"% &plusmn;10%")).replace("$airpressure",data.airpressure.toFixed(1)+"hPa &plusmn;30hPa")},replaceDeclarationConform=function(template,calData){let conformFlg=!0;for(let idx=0;idx<calData.fe.length;idx++)if(!calData.fe[idx].conformity){conformFlg=!1;break}for(let idx=0;idx<calData.nfe.length;idx++)if(!calData.nfe[idx].conformity){conformFlg=!1;break}return template=conformFlg?template.replace('conform2">&cross;','conform2">&nbsp;'):template.replace('conform1">✓','conform1">&nbsp;')},buildMeasurementTable=function(content,calData){let startpos,endpos,block,template;if(calData.fe.length>0){let blockFe="";startpos=content.indexOf("\x3c!--Fe--\x3e")+9,endpos=content.indexOf("\x3c!--Fe-End--\x3e"),template=content.substring(startpos,endpos);for(let idx=0;idx<calData.fe.length;idx++)if(Math.floor((calData.fe.length-2)/2)===idx?calData.fe[idx].conformity?blockFe+=template:blockFe+=template.replace("&#10003;","&cross;").replace("col-conf","notConform"):calData.fe[idx].conformity?blockFe+=template.replace('<div id="txt-fe">Fe</div>',""):blockFe+=template.replace('<div id="txt-fe">Fe</div>',"").replace("&#10003;","&cross;").replace("col-conf","notConform"),blockFe=blockFe.replace("$VALFE0",calData.fe[idx].nominal_um),blockFe=blockFe.replace("$VALFE1",calData.fe[idx].nominal_mil),blockFe=blockFe.replace("$VALFE2",calData.fe[idx].foilTol_um),blockFe=blockFe.replace("$VALFE3",calData.fe[idx].foilTol_mil),blockFe=blockFe.replace("$VALFE4",calData.fe[idx].val_um),blockFe=blockFe.replace("$VALFE5",calData.fe[idx].val_mil),blockFe=blockFe.replace("$VALFE6",calData.fe[idx].min_um),blockFe=blockFe.replace("$VALFE7",calData.fe[idx].min_mil),blockFe=blockFe.replace("$VALFE8",calData.fe[idx].max_um),blockFe=blockFe.replace("$VALFE9",calData.fe[idx].max_mil),idx<calData.fe.length-1){blockFe=blockFe.replace("border-180-b","");for(let col=1;col<12;col++)blockFe=blockFe.replace("border-180-b","border-180")}content=content.replace(template,blockFe)}else startpos=content.indexOf("\x3c!--Fe--\x3e")+9,endpos=content.indexOf("\x3c!--Fe-End--\x3e"),block=content.substring(startpos,endpos),content=content.replace(block,"");if(calData.nfe.length>0){let blockNFe="";startpos=content.indexOf("\x3c!--NFe--\x3e")+10,endpos=content.indexOf("\x3c!--NFeEnd--\x3e"),template=content.substring(startpos,endpos);for(let idx=0;idx<calData.nfe.length;idx++)idx>0?Math.floor((calData.nfe.length-2)/2)===idx?calData.nfe[idx].conformity?blockNFe+=template.replace("border-0-b",""):blockNFe+=template.replace("border-0-b","").replace("&#10003;","&cross;").replace("col-conf","notConform"):calData.nfe[idx].conformity?blockNFe+=template.replace("border-0-b","").replace('<div id="txt-nfe">NFe</div>',""):blockNFe+=template.replace("border-0-b","").replace('<div id="txt-nfe">NFe</div>',"").replace("&#10003;","&cross;").replace("col-conf","notConform"):calData.nfe[idx].conformity?blockNFe+=template.replace('<div id="txt-nfe">NFe</div>',""):blockNFe+=template.replace('<div id="txt-nfe">NFe</div>',"").replace("&#10003;","&cross;").replace("col-conf","notConform"),blockNFe=blockNFe.replace("$VALNFE0",calData.nfe[idx].nominal_um),blockNFe=blockNFe.replace("$VALNFE1",calData.nfe[idx].nominal_mil),blockNFe=blockNFe.replace("$VALNFE2",calData.nfe[idx].foilTol_um),blockNFe=blockNFe.replace("$VALNFE3",calData.nfe[idx].foilTol_mil),blockNFe=blockNFe.replace("$VALNFE4",calData.nfe[idx].val_um),blockNFe=blockNFe.replace("$VALNFE5",calData.nfe[idx].val_mil),blockNFe=blockNFe.replace("$VALNFE6",calData.nfe[idx].min_um),blockNFe=blockNFe.replace("$VALNFE7",calData.nfe[idx].min_mil),blockNFe=blockNFe.replace("$VALNFE8",calData.nfe[idx].max_um),blockNFe=blockNFe.replace("$VALNFE9",calData.nfe[idx].max_mil);content=content.replace(template,blockNFe)}else startpos=content.indexOf("\x3c!--NFe--\x3e")+10,endpos=content.indexOf("\x3c!--NFeEnd--\x3e"),template=content.substring(startpos,endpos),content=content.replace(template,"");return content=replaceDeclarationConform(content,calData)},calcMinMax=function(val,accuracy){let diff={min:val,max:val};for(let i=0;i<accuracy.length;i++)if(val<=accuracy[i].end){diff.min=val*(100-accuracy[i].percent)/100-accuracy[i].offset,diff.max=val*(100+accuracy[i].percent)/100+accuracy[i].offset;break}return diff};module.exports={buildHTMLcertificate(calData,probeData,certData,certData2,HG){let content=loadCertificateTemplate(certData2.path,certData2.code);if(""===content)return!0;if(6===certData.template)for(let i=0;i<2;i++)content=content.replace("$gaugeKey",HG.Key),content=content.replace("$gaugeSN",HG.SN);return content=replaceCertificateData(content,certData,certData2,probeData),content=replaceConditionData(content,certData.conditions),content=buildMeasurementTable(content,calData),saveCertificateFile(content)},saveCertificateList(content){let templateHeader=loadCertificateTemplateEvelope("header.dat");return saveCertificateFile(templateHeader+content)},loadQNDBdata(resultFunc){let content;try{console.log("QNDBdata path = "+pathQNDBfile),content=fs.readJsonSync(pathQNDBfile),resultFunc(!1,content)}catch(e){content={},resultFunc(new Error("error - load QNDB data"))}},indentifyDataSets(qndb,certData){let lang1,lang2,set=qndb.language.find((elem=>elem.pk===parseInt(certData.lang)));if(void 0!==set?(certData.code=set.code.toUpperCase(),certData.code.length>3?(lang1=certData.code.substring(0,3),lang2=certData.code.substring(4,7)):(lang1=certData.code,lang2="ENG")):(lang1="DEU",lang2="ENG"),set=qndb.pkey.find((elem=>elem.key===certData.key)),certData.accuracyFe=[],certData.accuracyNFe=[],void 0!==set){certData.probeLANG1=eval("set.certificatetext"+lang1),certData.probeLANG2=eval("set.certificatetext"+lang2);for(let i=0;i<set.accuracy.length;i++)"Fe"===set.accuracy[i].substrat?certData.accuracyFe.push({start:set.accuracy[i].start,end:set.accuracy[i].end,percent:set.accuracy[i].percent,offset:set.accuracy[i].offset}):"NFe"===set.accuracy[i].substrat&&certData.accuracyNFe.push({start:set.accuracy[i].start,end:set.accuracy[i].end,percent:set.accuracy[i].percent,offset:set.accuracy[i].offset})}else certData.probeLANG1=certData.designation,certData.probeLANG2=certData.designation;return set=qndb.pkey.find((elem=>elem.pk===certData.foilsetFe_productkey||elem.pk===certData.foilsetNFe_productkey)),certData.foilset_productkey=void 0!==set?set.key:"",set=qndb.tester.find((elem=>elem.pk===parseInt(certData.tester))),certData.tester={name:"",signature:""},void 0!==set&&(certData.tester.name=set.forename+" "+set.name,certData.tester.signature=set.signature),set=qndb.tester.find((elem=>elem.pk===parseInt(certData.supervisor))),certData.supervisor={name:"",signature:""},void 0!==set&&(certData.supervisor.name=set.forename+" "+set.name,certData.supervisor.signature=set.signature),set=qndb.refdevice.find((elem=>elem.pk===parseInt(certData.refdevice))),void 0!==set?(certData.refStandard=set.designation,certData.refSerial=set.serialnumber.toString(),certData.refMark=set.officialreference,certData.refDate=set.calibrationdate):(certData.refStandard="Heidenhain",certData.refSerial="",certData.refMark="-",certData.refDate=""),set=qndb.template.find((elem=>elem.pk===parseInt(certData.template))),certData.path=void 0!==set?set.path:"11313000AA\\11313000AA",certData},processingCalData(calData,foils,certData2){let row,idxFoil,foilVal,foilTol,pointVal,calibrationData={fe:[],nfe:[]},tol={};for(let idx=0;idx<calData.fe.length;idx++)row={},idxFoil=calData.fe[idx].standard1-1,foilVal=foils[idxFoil][1],row.nominal_um=conv.formatVal_um(foilVal),row.nominal_mil=conv.formatVal_mil(foilVal),foilTol=foils[idxFoil][2],row.foilTol_um=conv.formatVal_um(foilTol),row.foilTol_mil=conv.formatVal_mil(foilTol),pointVal=calData.fe[idx].val,row.val_um=conv.formatVal_um(pointVal),row.val_mil=conv.formatVal_mil(pointVal),certData2.accuracyFe.length>0?tol=calcMinMax(foilVal,certData2.accuracyFe):(tol.min=foilVal-calData.fe[idx].tol,tol.max=foilVal+calData.fe[idx].tol),row.min_um=conv.formatVal_um(tol.min+foilTol),row.min_mil=conv.formatVal_mil(tol.min+foilTol),row.max_um=conv.formatVal_um(tol.max-foilTol),row.max_mil=conv.formatVal_mil(tol.max-foilTol),row.conformity=testConformity(row),calibrationData.fe.push(row);for(let idx=0;idx<calData.nfe.length;idx++)row={},idxFoil=calData.nfe[idx].standard1-1,foilVal=foils[idxFoil][1],row.nominal_um=conv.formatVal_um(foilVal),row.nominal_mil=conv.formatVal_mil(foilVal),foilTol=foils[idxFoil][2],row.foilTol_um=conv.formatVal_um(foilTol),row.foilTol_mil=conv.formatVal_mil(foilTol),pointVal=calData.nfe[idx].val,row.val_um=conv.formatVal_um(pointVal),row.val_mil=conv.formatVal_mil(pointVal),certData2.accuracyNFe.length>0?tol=calcMinMax(foilVal,certData2.accuracyNFe):(tol.min=foilVal-calData.nfe[idx].tol,tol.max=foilVal+calData.nfe[idx].tol),row.min_um=conv.formatVal_um(tol.min+foilTol),row.min_mil=conv.formatVal_mil(tol.min+foilTol),row.max_um=conv.formatVal_um(tol.max-foilTol),row.max_mil=conv.formatVal_mil(tol.max-foilTol),row.conformity=testConformity(row),calibrationData.nfe.push(row);return calibrationData},getHTMLCertName:()=>tempCertificateFilename,getPDFCertName(){let p=Path.join(pathTemp,certFileName);return console.log("certFile = "+p),p}};