# Contributing

By participating in this project, you
agree to abide by the thoughtbot [code of conduct].

[code of conduct]: https://thoughtbot.com/open-source-code-of-conduct

- Fork, then clone the repo:

```
git clone git@github.com:your-username/excel4node.git
```
- Install package dependencies

```
npm install
```

- Make sure the tests pass:

```
npm run test
```

- Make your change. Add tests for your change. Make the tests pass:

```
npm run test
```

- Validate generated sample Excel workbook against the xlsx-validator

__This requires Docker be installed on your system to run the xlsx-validator Docker image__

```
npm run build
node sample.js
./validate.sh Excel.xlsx
```

- All library code is contained in the source directory. Running 'npm run watch' will start a babel watch process and transpile output to the distribution directory. 

- Document your change in code using [jsdoc] conventions
- Update the README.md file with instructions on how how use your change

- Push to your fork and [submit a pull request][pr].


Please follow the [style guide][style].

[pr]: https://github.com/natergj/excel4node/compare
[style]: https://github.com/natergj/excel4node/blob/master/.eslintrc.js
[jsdoc]: http://usejsdoc.org/